package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.cdn.mapper.MappingSet;

import java.util.List;

/**
 * Final/merged instances of this class should hold all possible web-resource URLs variations for given product state.
 *
 * @see DiscoveryTask
 * @since v3.5.0
 */
public interface WebResourceBatch {

    /**
     * @return string which reflects current product state,
     * e.g. hash created from normalized set of product + plugins names/versions.
     */
    String getVersion();

    /**
     * @return string representing path to the bundle.zip of this batch.
     */
    String getBundle();

    void addCrawlerResult(CrawlerResult cr);

    /**
     * @return set of URL mappings.
     */
    MappingSet getMappings();

    List<TaintedResource> getTaintedResources();

}
