package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.cdn.mapper.DefaultMappingSet;
import com.atlassian.plugin.webresource.cdn.mapper.Mapping;
import com.atlassian.plugin.webresource.cdn.mapper.MappingSet;
import com.google.common.collect.ImmutableList;

import javax.annotation.concurrent.NotThreadSafe;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

import static com.atlassian.webresource.plugin.prebake.util.PreBakeUtil.RELATIVE_ZIP;
import static com.atlassian.webresource.plugin.prebake.util.PreBakeUtil.SEPRTR;

/**
 * Default implementation of {@link WebResourceBatch}.
 *
 * @since v3.5.0
 */
@NotThreadSafe
public class DefaultWebResourceBatch implements WebResourceBatch {

    private final String version;
    private final String bundle;

    // The order is important for debugging and reproducibility
    private final LinkedHashSet<Mapping> mappings = new LinkedHashSet<>();
    // Debugging
    private final List<TaintedResource> taintedResources = new ArrayList<>();

    public DefaultWebResourceBatch(String version) {
        this.version = version;
        this.bundle = version + SEPRTR + RELATIVE_ZIP;
    }

    @Override
    public final String getVersion() {
        return version;
    }

    @Override
    public String getBundle() {
        return bundle;
    }

    @Override
    public final MappingSet getMappings() {
        return new DefaultMappingSet(mappings);
    }

    @Override
    public void addCrawlerResult(CrawlerResult cr) {
        cr.getMappingSet().all().spliterator().forEachRemaining(mappings::add);
        taintedResources.addAll(cr.getTaintedResources());
    }

    @Override
    public List<TaintedResource> getTaintedResources() {
        return ImmutableList.copyOf(taintedResources);
    }

}
