package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.cdn.mapper.DefaultMappingSet;
import com.atlassian.plugin.webresource.cdn.mapper.MappingSet;

import java.util.Collections;
import java.util.List;

/**
 * Wrapper class for storing the results of a {@link WebResourceCrawler}.
 *
 * @since 3.5.9
 */
public final class CrawlerResult {

    public static final CrawlerResult EMPTY =
            new CrawlerResult(
                    DefaultMappingSet.EMPTY,
                    Collections.emptyList()
            );

    private final MappingSet mappingSet;
    private final List<TaintedResource> taintedResources;

    protected CrawlerResult(
            MappingSet mappingSet,
            List<TaintedResource> taintedResources) {
        this.mappingSet = mappingSet;
        this.taintedResources = taintedResources;
    }

    /**
     * Indicates if errors occurred during the crawling operation
     *
     * @return true if the crawling operation has generated errors, false otherwise
     * @since 3.5.9
     */
    public boolean hasErrors() {
        return !taintedResources.isEmpty();
    }

    /**
     * Returns the set of pre-baking mappings generated by the crawler
     *
     * @return pre-baked resource mappings
     * @since 3.5.9
     */
    public MappingSet getMappingSet() {
        return mappingSet;
    }

    /**
     * Returns the list of resources marked as "tainted" during the crawling operation.
     * See {@link TaintedResource} for more information.
     *
     * @return List of resources that the crawler identified as "tainted"
     * @since 3.5.9
     */
    public List<TaintedResource> getTaintedResources() {
        return taintedResources;
    }

}
