package com.atlassian.webresource.plugin.rest;

import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.webresource.plugin.async.AsyncWebResourceLoader;
import com.google.common.collect.Sets;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;

/**
 * REST endpoint for retrieving list of js and css resources
 * @since v3.0
 */
@AnonymousAllowed
@Path("resources")
@Consumes({ MediaType.APPLICATION_JSON })
@Produces({ MediaType.APPLICATION_JSON })
public class ListOfResources
{
    private final AsyncWebResourceLoader asyncWebResourceLoader;

    public ListOfResources(AsyncWebResourceLoader asyncWebResourceLoader)
    {
        this.asyncWebResourceLoader = asyncWebResourceLoader;
    }

    @GET
    public Iterable<AsyncWebResourceLoader.Resource> list(@QueryParam("r") String webResources, @QueryParam("c") String contexts,
                                     @QueryParam("xr") String excludeResources, @QueryParam("xc") String excludeContexts)
    {
        return asyncWebResourceLoader.resolve(asSet(webResources), asSet(contexts),
                asSet(excludeResources), asSet(excludeContexts));
    }

    private Set<String> asSet(String str)
    {
        if (null == str || "".equals(str))
        {
            return Collections.emptySet();
        }
        else
        {
            return Sets.newLinkedHashSet(Arrays.asList(str.split(",")));
        }
    }
}
