/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.api.prebake;

import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.CoordinateImpl;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.atlassian.webresource.api.prebake.QueryParam;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class DimensionsImpl
implements Dimensions {
    private final SortedMap<String, Set<Optional<String>>> queryParams = new TreeMap<String, Set<Optional<String>>>();

    private DimensionsImpl() {
    }

    private DimensionsImpl(SortedMap<String, Set<Optional<String>>> a, SortedMap<String, Set<Optional<String>>> b) {
        this.queryParams.putAll(a);
        for (Map.Entry<String, Set<Optional<String>>> entry : b.entrySet()) {
            String key = entry.getKey();
            if (!this.queryParams.containsKey(key)) {
                this.queryParams.put(key, new LinkedHashSet());
            }
            ((Set)this.queryParams.get(key)).addAll((Collection)entry.getValue());
        }
    }

    private DimensionsImpl(SortedMap<String, Set<Optional<String>>> orig, String key, Collection<Optional<String>> more) {
        this.queryParams.putAll(orig);
        if (!this.queryParams.containsKey(key)) {
            this.queryParams.put(key, new LinkedHashSet());
        }
        ((Set)this.queryParams.get(key)).addAll(more);
    }

    public static Dimensions empty() {
        return new DimensionsImpl();
    }

    @Override
    public Dimensions andExactly(String key, String ... values) {
        return this.andExactly(key, Arrays.asList(values));
    }

    @Override
    public Dimensions andExactly(String key, Collection<String> values) {
        List<Optional<String>> optionalValues = values.stream().map(Optional::ofNullable).collect(Collectors.toList());
        return new DimensionsImpl(this.queryParams, key, optionalValues);
    }

    @Override
    public Dimensions andAbsent(String key) {
        return new DimensionsImpl(this.queryParams, key, Collections.singleton(Optional.empty()));
    }

    @Override
    public Dimensions product(Dimensions rhs) {
        return new DimensionsImpl(this.queryParams, ((DimensionsImpl)rhs).queryParams);
    }

    @Override
    public Stream<Coordinate> cartesianProduct() {
        ArrayList cartesianInput = Lists.newArrayList();
        for (Map.Entry<String, Set<Optional<String>>> entry : this.queryParams.entrySet()) {
            LinkedHashSet axis = Sets.newLinkedHashSet();
            for (Optional<String> value : entry.getValue()) {
                axis.add(new QueryParam(entry.getKey(), value));
            }
            cartesianInput.add(axis);
        }
        Set cartesianProduct = Sets.cartesianProduct((List)cartesianInput);
        return cartesianProduct.stream().map(CoordinateImpl::new);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimensionsImpl that = (DimensionsImpl)o;
        return this.queryParams.equals(that.queryParams);
    }

    public int hashCode() {
        return this.queryParams.hashCode();
    }

    public String toString() {
        return "Dimensions{queryParams=" + this.queryParams + '}';
    }
}

