package com.atlassian.webresource.api.prebake;

import com.google.common.collect.Sets;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import static com.google.common.collect.Lists.newArrayList;
import static com.google.common.collect.Sets.newLinkedHashSet;
import static java.util.Arrays.asList;

/**
 */
class DimensionsImpl implements Dimensions
{
    /** sorted map for easier debugging */
    private final SortedMap<String, Set<Optional<String>>> queryParams = new TreeMap<>();

    private DimensionsImpl()
    {
    }

    private DimensionsImpl(SortedMap<String, Set<Optional<String>>> a, SortedMap<String, Set<Optional<String>>> b)
    {
        queryParams.putAll(a);
        for (Map.Entry<String, Set<Optional<String>>> entry : b.entrySet())
        {
            String key = entry.getKey();
            if (!queryParams.containsKey(key)) {
                this.queryParams.put(key, new LinkedHashSet<>());
            }
            this.queryParams.get(key).addAll(entry.getValue());
        }
    }
    private DimensionsImpl(SortedMap<String, Set<Optional<String>>> orig, String key, Collection<Optional<String>> more)
    {
        queryParams.putAll(orig);
        if (!queryParams.containsKey(key)) {
            this.queryParams.put(key, new LinkedHashSet<>());
        }
        this.queryParams.get(key).addAll(more);
    }

    public static Dimensions empty()
    {
        return new DimensionsImpl();
    }

    @Override
    public Dimensions andExactly(String key, String... values)
    {
        return andExactly(key, asList(values));
    }

    @Override
    public Dimensions andExactly(String key, Collection<String> values)
    {
        List<Optional<String>> optionalValues = values.stream().map(Optional::ofNullable).collect(Collectors.toList());
        return new DimensionsImpl(queryParams, key, optionalValues);
    }

    @Override
    public Dimensions andAbsent(String key)
    {
        return new DimensionsImpl(queryParams, key, Collections.singleton(Optional.<String>empty()));
    }

    @Override
    public Dimensions product(Dimensions rhs)
    {
        return new DimensionsImpl(queryParams, ((DimensionsImpl) rhs).queryParams);
    }

    @Override
    public Stream<Coordinate> cartesianProduct()
    {
        List<Set<QueryParam>> cartesianInput = newArrayList();
        for (Map.Entry<String, Set<Optional<String>>> entry : queryParams.entrySet())
        {
            Set<QueryParam> axis = newLinkedHashSet();
            for (Optional<String> value : entry.getValue())
            {
                axis.add(new QueryParam(entry.getKey(), value));
            }
            cartesianInput.add(axis);
        }

        Set<List<QueryParam>> cartesianProduct = Sets.cartesianProduct(cartesianInput);
        return cartesianProduct.stream().map(CoordinateImpl::new);
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        DimensionsImpl that = (DimensionsImpl) o;

        return queryParams.equals(that.queryParams);

    }

    @Override
    public int hashCode()
    {
        return queryParams.hashCode();
    }

    @Override
    public String toString()
    {
        return "Dimensions{" +
                "queryParams=" + queryParams +
                '}';
    }


}
