package com.atlassian.webresource.api.assembler;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.json.marshal.Jsonable;

import java.util.Set;

/**
 * Interface for clients to require web resources.
 * @since v3.0
 */
@ExperimentalApi
public interface RequiredResources
{
    /**
     * Specifies that resources for the given module should be included on the next call to drainIncludedResources().
     * @param moduleCompleteKey key of webresource module
     * @return this, to support method chaining
     */
    public RequiredResources requireWebResource(String moduleCompleteKey);

    /**
     * Specifies that resources for the given webresource context should be included on the next call to
     * drainIncludedResources().
     * @param context webresource context to include
     * @return this, to support method chaining
     */
    public RequiredResources requireContext(String context);

    /**
     * Specifies that the given resources should be excluded from all future calls to drainIncludedResources().
     * This is equivalent to requiring the given webresources and contexts then calling drain().
     * If this WebResourceAssembler was constructed with excludeSuperbatch = false, this will also exclude all
     * superbatch resources from future calls to drainIncludedResources().
     * @param webResources webresource keys to exclude.
     * @param contexts contexts to exclude.
     * @return this, to support method chaining
     */
    public RequiredResources exclude(Set<String> webResources, Set<String> contexts);
}
