package com.atlassian.plugin.web.model;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import org.dom4j.Element;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * A simple bean to represent labels in the web interface.
 */
public class DefaultWebLabel extends DefaultWebParam implements WebLabel {
    private final String key;
    private final String noKeyValue;

    public DefaultWebLabel(Element labelEl, WebFragmentHelper webFragmentHelper, ContextProvider contextProvider, WebFragmentModuleDescriptor descriptor) throws PluginParseException {
        super(labelEl, webFragmentHelper, contextProvider, descriptor);
        if (labelEl == null) {
            throw new PluginParseException("You must specify a label for the section.");
        } else {
            this.key = labelEl.attributeValue("key");

            if (this.key == null) {
                this.noKeyValue = labelEl.getTextTrim();
            } else {
                this.noKeyValue = null;
            }
        }
    }

    public String getKey() {
        return key;
    }

    public String getNoKeyValue() {
        return noKeyValue;
    }

    public String getDisplayableLabel(HttpServletRequest req, Map<String, Object> origContext) {
        final Map<String, Object> tmpContext = new HashMap<>(origContext);
        tmpContext.putAll(getContextMap(tmpContext));
        if (key != null) {
            if (params == null || params.isEmpty()) {
                return getWebFragmentHelper().getI18nValue(key, null, tmpContext);
            } else {
                final List<String> arguments = new ArrayList<>();

                // we know here because it's a tree map that the params are in alphabetical order
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    if (entry.getKey().startsWith("param"))
                        arguments.add(getWebFragmentHelper().renderVelocityFragment(entry.getValue(), tmpContext));
                }

                return getWebFragmentHelper().getI18nValue(key, arguments, tmpContext);
            }
        } else {
            return getWebFragmentHelper().renderVelocityFragment(noKeyValue, tmpContext);
        }
    }
}
