/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.loaders.LoaderUtils;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.conditions.AbstractCompositeCondition;
import com.atlassian.plugin.web.conditions.AndCompositeCondition;
import com.atlassian.plugin.web.conditions.ConditionLoadingException;
import com.atlassian.plugin.web.conditions.InvertedCondition;
import com.atlassian.plugin.web.conditions.OrCompositeCondition;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConditionElementParser {
    private final WebFragmentHelper webFragmentHelper;

    public ConditionElementParser(WebFragmentHelper webFragmentHelper) {
        this.webFragmentHelper = webFragmentHelper;
    }

    public Condition makeConditions(Plugin plugin, Element element, int type) throws PluginParseException {
        Assertions.notNull((String)"plugin == null", (Object)plugin);
        List singleConditionElements = element.elements("condition");
        Condition singleConditions = null;
        if (singleConditionElements != null && !singleConditionElements.isEmpty()) {
            singleConditions = this.makeConditions(plugin, singleConditionElements, type);
        }
        List nestedConditionsElements = element.elements("conditions");
        AbstractCompositeCondition nestedConditions = null;
        if (nestedConditionsElements != null && !nestedConditionsElements.isEmpty()) {
            nestedConditions = this.getCompositeCondition(type);
            for (Element nestedElement : nestedConditionsElements) {
                nestedConditions.addCondition(this.makeConditions(plugin, nestedElement, CompositeType.parse(nestedElement.attributeValue("type"))));
            }
        }
        if (singleConditions != null && nestedConditions != null) {
            AbstractCompositeCondition compositeCondition = this.getCompositeCondition(type);
            compositeCondition.addCondition(singleConditions);
            compositeCondition.addCondition(nestedConditions);
            return compositeCondition;
        }
        if (singleConditions != null) {
            return singleConditions;
        }
        if (nestedConditions != null) {
            return nestedConditions;
        }
        return null;
    }

    public Condition makeConditions(Plugin plugin, List<Element> elements, int type) throws PluginParseException {
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return this.makeCondition(plugin, elements.get(0));
        }
        AbstractCompositeCondition compositeCondition = this.getCompositeCondition(type);
        for (Element element : elements) {
            compositeCondition.addCondition(this.makeCondition(plugin, element));
        }
        return compositeCondition;
    }

    public Condition makeCondition(Plugin plugin, Element element) throws PluginParseException {
        try {
            Condition condition = this.webFragmentHelper.loadCondition(element.attributeValue("class"), plugin);
            condition.init(LoaderUtils.getParams((Element)element));
            if (element.attribute("invert") != null && "true".equals(element.attributeValue("invert"))) {
                return new InvertedCondition(condition);
            }
            return condition;
        }
        catch (ClassCastException e) {
            throw new PluginParseException("Configured condition class does not implement the Condition interface", (Throwable)e);
        }
        catch (ConditionLoadingException cle) {
            throw new PluginParseException("Unable to load the module's display conditions: " + cle.getMessage(), (Throwable)((Object)cle));
        }
    }

    private AbstractCompositeCondition getCompositeCondition(int type) throws PluginParseException {
        switch (type) {
            case 0: {
                return new OrCompositeCondition();
            }
            case 1: {
                return new AndCompositeCondition();
            }
        }
        throw new PluginParseException("Invalid condition type specified. type = " + type);
    }

    static class CompositeType {
        static final int OR = 0;
        static final int AND = 1;

        CompositeType() {
        }

        static int parse(String type) throws PluginParseException {
            if ("or".equalsIgnoreCase(type)) {
                return 0;
            }
            if ("and".equalsIgnoreCase(type)) {
                return 1;
            }
            throw new PluginParseException("Invalid condition type specified. type = " + type);
        }
    }
}

