/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring;

import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.ContextClassLoaderStrategy;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.plugin.util.Assertions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.HierarchicalBeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value="hostComponentProvider")
public class SpringHostComponentProviderFactoryBean
extends AbstractFactoryBean {
    private static final Log log = LogFactory.getLog(SpringHostComponentProviderFactoryBean.class);
    private Set<String> beanNames;
    private Map<String, Class[]> beanInterfaces;
    private Map<String, ContextClassLoaderStrategy> beanContextClassLoaderStrategies;
    private boolean useAnnotation = true;

    public Class getObjectType() {
        return HostComponentProvider.class;
    }

    protected Object createInstance() throws Exception {
        return new SpringHostComponentProvider(this.getBeanFactory(), this.beanNames, this.beanInterfaces, this.beanContextClassLoaderStrategies, this.useAnnotation);
    }

    public void setBeanNames(Set<String> beanNames) {
        this.beanNames = beanNames;
    }

    public void setBeanInterfaces(Map<String, Class[]> beanInterfaces) {
        this.beanInterfaces = beanInterfaces;
    }

    public void setBeanContextClassLoaderStrategies(Map<String, ContextClassLoaderStrategy> beanContextClassLoaderStrategies) {
        this.beanContextClassLoaderStrategies = beanContextClassLoaderStrategies;
    }

    public void setUseAnnotation(boolean useAnnotation) {
        this.useAnnotation = useAnnotation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpringHostComponentProvider
    implements HostComponentProvider {
        private final BeanFactory beanFactory;
        private boolean useAnnotation;
        private final Set<String> beanNames;
        private final Map<String, Class[]> beanInterfaces;
        private final Map<String, ContextClassLoaderStrategy> beanContextClassLoaderStrategies;

        public SpringHostComponentProvider(BeanFactory beanFactory, Set<String> beanNames, Map<String, Class[]> beanInterfaces, Map<String, ContextClassLoaderStrategy> beanContextClassLoaderStrategies, boolean useAnnotation) {
            this.beanFactory = (BeanFactory)Assertions.notNull((String)"beanFactory", (Object)beanFactory);
            this.useAnnotation = useAnnotation;
            this.beanNames = beanNames != null ? beanNames : new HashSet();
            this.beanInterfaces = beanInterfaces != null ? beanInterfaces : new HashMap();
            this.beanContextClassLoaderStrategies = beanContextClassLoaderStrategies != null ? beanContextClassLoaderStrategies : new HashMap();
        }

        public void provide(ComponentRegistrar registrar) {
            BeanFactory parentBeanFactory;
            HashSet<String> beansToProvide = new HashSet<String>(this.beanNames);
            HashMap<String, Class[]> interfacesToProvide = new HashMap<String, Class[]>(this.beanInterfaces);
            HashMap<String, ContextClassLoaderStrategy> contextClassLoaderStrategiesToProvide = new HashMap<String, ContextClassLoaderStrategy>(this.beanContextClassLoaderStrategies);
            if (this.useAnnotation) {
                this.scanForAnnotatedBeans(beansToProvide, interfacesToProvide, contextClassLoaderStrategiesToProvide);
            }
            this.provideBeans(registrar, beansToProvide, interfacesToProvide, contextClassLoaderStrategiesToProvide);
            if (this.beanFactory instanceof HierarchicalBeanFactory && (parentBeanFactory = ((HierarchicalBeanFactory)this.beanFactory).getParentBeanFactory()) != null) {
                try {
                    HostComponentProvider provider = (HostComponentProvider)parentBeanFactory.getBean("hostComponentProvider");
                    if (provider != null) {
                        provider.provide(registrar);
                    }
                }
                catch (NoSuchBeanDefinitionException e) {
                    log.debug((Object)("Unable to find 'hostComponentProvider' in the parent bean factory " + parentBeanFactory));
                }
            }
        }

        private void provideBeans(ComponentRegistrar registrar, Set<String> beanNames, Map<String, Class[]> beanInterfaces, Map<String, ContextClassLoaderStrategy> beanContextClassLoaderStrategies) {
            for (String beanName : beanNames) {
                if (this.beanFactory.isSingleton(beanName)) {
                    Object bean = this.beanFactory.getBean(beanName);
                    Class[] interfaces = beanInterfaces.get(beanName);
                    if (interfaces == null) {
                        interfaces = this.findInterfaces(this.getBeanClass(bean));
                    }
                    registrar.register(interfaces).forInstance(bean).withName(beanName).withContextClassLoaderStrategy(beanContextClassLoaderStrategies.containsKey(beanName) ? beanContextClassLoaderStrategies.get(beanName) : ContextClassLoaderStrategy.USE_HOST);
                    continue;
                }
                log.warn((Object)("Cannot register bean '" + beanName + "' as it's scope is not singleton"));
            }
        }

        private void scanForAnnotatedBeans(Set<String> beansToProvide, Map<String, Class[]> interfacesToProvide, Map<String, ContextClassLoaderStrategy> contextClassLoaderStrategiesToProvide) {
            if (this.beanFactory instanceof ListableBeanFactory) {
                for (String beanName : ((ListableBeanFactory)this.beanFactory).getBeanDefinitionNames()) {
                    try {
                        if (!this.beanFactory.isSingleton(beanName)) continue;
                        Class beanClass = this.getBeanClass(this.beanFactory.getBean(beanName));
                        AvailableToPlugins annotation = (AvailableToPlugins)AnnotationUtils.findAnnotation((Class)beanClass, AvailableToPlugins.class);
                        if (annotation != null) {
                            beansToProvide.add(beanName);
                            if (annotation.value() != Void.class) {
                                if (!interfacesToProvide.containsKey(beanName)) {
                                    interfacesToProvide.put(beanName, new Class[]{annotation.value()});
                                } else {
                                    log.debug((Object)("Interfaces for bean '" + beanName + "' have been defined in XML or in a Module definition, ignoring the interface defined in the annotation"));
                                }
                            }
                            if (!contextClassLoaderStrategiesToProvide.containsKey(beanName)) {
                                contextClassLoaderStrategiesToProvide.put(beanName, annotation.contextClassLoaderStrategy());
                                continue;
                            }
                            log.debug((Object)("Context class loader strategy for bean '" + beanName + "' has been defined in XML or in a Module definition, ignoring the one defined in the annotation"));
                            continue;
                        }
                        log.warn((Object)("Cannot make bean '" + beanName + "' available to plugins as it is not scoped 'singleton'"));
                    }
                    catch (BeanIsAbstractException ex) {
                        // empty catch block
                    }
                }
            } else {
                log.warn((Object)"Could not scan bean factory for beans to make available to plugins, bean factory is not 'listable'");
            }
        }

        private Class[] findInterfaces(Class cls) {
            ArrayList<Class> validInterfaces = new ArrayList<Class>();
            for (Class inf : this.getAllInterfaces(cls)) {
                if (inf.getName().startsWith("org.springframework")) continue;
                validInterfaces.add(inf);
            }
            return validInterfaces.toArray(new Class[validInterfaces.size()]);
        }

        private List<Class> getAllInterfaces(Class cls) {
            return ClassUtils.getAllInterfaces((Class)cls);
        }

        private Class getBeanClass(Object bean) {
            return AopUtils.getTargetClass((Object)bean);
        }
    }
}

