/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet.filter;

import com.atlassian.plugin.servlet.PluginHttpRequestWrapper;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugin.servlet.util.ClassLoaderStack;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class DelegatingPluginFilter
implements Filter {
    private final ServletFilterModuleDescriptor descriptor;
    private final Filter filter;

    public DelegatingPluginFilter(ServletFilterModuleDescriptor descriptor) {
        this.descriptor = descriptor;
        this.filter = descriptor.getModule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig filterConfig) throws ServletException {
        ClassLoaderStack.push(this.descriptor.getPlugin().getClassLoader());
        try {
            this.filter.init(filterConfig);
        }
        finally {
            ClassLoaderStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        ClassLoaderStack.push(this.descriptor.getPlugin().getClassLoader());
        try {
            FilterChain resetContextClassLoaderChain = new FilterChain(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                    ClassLoaderStack.pop();
                    try {
                        chain.doFilter(servletRequest, servletResponse);
                    }
                    finally {
                        ClassLoaderStack.push(DelegatingPluginFilter.this.descriptor.getPlugin().getClassLoader());
                    }
                }
            };
            this.filter.doFilter((ServletRequest)new PluginHttpRequestWrapper((HttpServletRequest)request, this.descriptor), response, resetContextClassLoaderChain);
        }
        finally {
            ClassLoaderStack.pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ClassLoaderStack.push(this.descriptor.getPlugin().getClassLoader());
        try {
            this.filter.destroy();
        }
        finally {
            ClassLoaderStack.pop();
        }
    }

    public Filter getDelegatingFilter() {
        return this.filter;
    }
}

