/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.schema.impl;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.schema.descriptor.DescribedModuleDescriptorFactory;
import com.atlassian.plugin.schema.spi.Schema;
import com.atlassian.plugin.schema.spi.SchemaFactory;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Set;

class DefaultDescribedModuleDescriptorFactory<T extends ModuleDescriptor<?>>
implements DescribedModuleDescriptorFactory {
    private final OsgiPlugin plugin;
    private final String type;
    private final Iterable<String> typeList;
    private final Class<T> moduleDescriptorClass;
    private final SchemaFactory schemaFactory;

    DefaultDescribedModuleDescriptorFactory(OsgiPlugin plugin, String type, Class<T> moduleDescriptorClass, SchemaFactory schemaFactory) {
        this.plugin = (OsgiPlugin)Preconditions.checkNotNull((Object)plugin);
        this.moduleDescriptorClass = moduleDescriptorClass;
        this.type = type;
        this.schemaFactory = schemaFactory;
        this.typeList = Collections.singleton(type);
    }

    public ModuleDescriptor getModuleDescriptor(String type) throws PluginParseException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        ModuleDescriptor result = null;
        if (this.type.equals(type)) {
            result = (ModuleDescriptor)this.plugin.autowire(this.moduleDescriptorClass);
        }
        return result;
    }

    public boolean hasModuleDescriptor(String type) {
        return this.type.equals(type);
    }

    @Override
    public Iterable<String> getModuleDescriptorKeys() {
        return this.typeList;
    }

    @Override
    public Schema getSchema(String type) {
        return this.type.equals(type) ? this.schemaFactory.getSchema() : null;
    }

    public Class<? extends ModuleDescriptor<?>> getModuleDescriptorClass(String type) {
        return this.type.equals(type) ? this.moduleDescriptorClass : null;
    }

    public Set<Class<ModuleDescriptor<?>>> getModuleDescriptorClasses() {
        return Collections.singleton(this.moduleDescriptorClass);
    }
}

