/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.refimpl;

import com.atlassian.plugin.refimpl.ContainerManager;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class InitListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        this.initializeLogger();
        Logger.getLogger(InitListener.class).info((Object)"Logging initialized.");
        ContainerManager.setInstance((ContainerManager)new ContainerManager(sce.getServletContext()));
        ContainerManager mgr = ContainerManager.getInstance();
        mgr.getPluginAccessor().getPlugins();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        ContainerManager mgr = ContainerManager.getInstance();
        if (mgr != null) {
            mgr.shutdown();
        }
        ContainerManager.setInstance(null);
    }

    private void initializeLogger() {
        Properties logProperties = new Properties();
        try {
            logProperties.load(this.getClass().getResourceAsStream("/log4j.properties"));
            PropertyConfigurator.configure((Properties)logProperties);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load logging property", e);
        }
    }
}

