/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hook.dmz;

import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.hook.dmz.DmzResolverHook;
import com.atlassian.plugin.osgi.hook.dmz.PluginTypeDetector;
import com.atlassian.plugin.osgi.hook.dmz.packages.DmzPackagePatterns;
import com.atlassian.plugin.osgi.hook.dmz.packages.ExportTypeBasedInternalPackageDetector;
import java.util.Collection;
import java.util.Objects;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleRevision;

public class DmzResolverHookFactory
implements ResolverHookFactory {
    private final PackageScannerConfiguration config;

    public DmzResolverHookFactory(PackageScannerConfiguration packageScannerConfig) {
        this.config = Objects.requireNonNull(packageScannerConfig, "Configuration required.");
    }

    public ResolverHook begin(Collection<BundleRevision> triggers) {
        return this.createHook();
    }

    private ResolverHook createHook() {
        PluginTypeDetector pluginTypeDetector = new PluginTypeDetector(this.config.getApplicationBundledInternalPlugins());
        DmzPackagePatterns dmzPackagePatterns = new DmzPackagePatterns(this.config.getOsgiPublicPackages(), this.config.getOsgiPublicPackagesExcludes(), this.config.getOsgiDeprecatedPackages());
        ExportTypeBasedInternalPackageDetector internalPackageDetector = new ExportTypeBasedInternalPackageDetector(dmzPackagePatterns, pluginTypeDetector);
        return new DmzResolverHook(pluginTypeDetector, internalPackageDetector, this.config.treatDeprecatedPackagesAsPublic());
    }
}

