/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.internal.hook.rest;

import com.atlassian.plugin.osgi.hook.dmz.PluginTypeDetector;
import com.atlassian.plugin.osgi.hook.rest.RestVersionUtils;
import java.net.URL;
import java.util.Objects;
import java.util.function.Predicate;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaxRsFilterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaxRsFilterFactory.class);
    public static final String INTERNAL_REST_V1_ACCESS_FEATURE_KEY = "atlassian.plugins.internal.rest.v1.access.enabled";
    public static final Predicate<BundleCapability> FILTER_REST_V1 = bundleCapability -> RestVersionUtils.isCapabilityWithMajorVersion(bundleCapability, 1);
    public static final Predicate<BundleCapability> FILTER_REST_V2 = bundleCapability -> RestVersionUtils.isCapabilityWithMajorVersion(bundleCapability, 2);
    private final PluginTypeDetector pluginDetector;

    public JaxRsFilterFactory(PluginTypeDetector pluginDetector) {
        this.pluginDetector = Objects.requireNonNull(pluginDetector, "Plugin detector is required.");
    }

    public Predicate<BundleCapability> getFilter(Bundle bundle) {
        boolean isInternalPlugin = this.pluginDetector.isInternalPlugin(bundle);
        URL pluginDescriptor = bundle.getEntry("atlassian-plugin.xml");
        Document read = null;
        try {
            read = new SAXReader().read(pluginDescriptor);
            return this.getFilter(read, isInternalPlugin);
        }
        catch (DocumentException e) {
            LOGGER.warn(String.format("Cannot parse plugin descriptor for bundle %s; no filtering of JAX-RS package", bundle.getSymbolicName()), (Throwable)e);
            return ignored -> true;
        }
    }

    public Predicate<BundleCapability> getFilter(Document pluginXml, boolean isInternalPlugin) {
        Element restMigration = pluginXml.getRootElement().element("rest-migration");
        boolean hasRestV2 = restMigration != null && restMigration.element("rest-v2") != null;
        boolean canAccessRestV1 = Boolean.getBoolean(INTERNAL_REST_V1_ACCESS_FEATURE_KEY);
        if (canAccessRestV1 && isInternalPlugin && !hasRestV2) {
            return FILTER_REST_V1;
        }
        return FILTER_REST_V2;
    }
}

