/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.container.felix;

import java.util.function.Function;

public final class FelixUtils {
    private FelixUtils() {
    }

    public static void sortRestDescriptorFactory(Object[] services) {
        FelixUtils.sortRestDescriptorFactory(services, service -> service.getClass().getName());
    }

    public static void sortRestDescriptorFactory(Object[] services, Function<Object, String> classNameProvider) {
        boolean isNewRestFirst;
        if (services == null) {
            return;
        }
        int oldRestIndex = -1;
        int newRestIndex = -1;
        for (int i = 0; i < services.length; ++i) {
            Object service = services[i];
            if (classNameProvider.apply(service).equals("com.atlassian.plugins.rest.module.RestModuleDescriptorFactory")) {
                oldRestIndex = i;
            }
            if (!classNameProvider.apply(service).equals("com.atlassian.plugins.rest.v2.descriptor.RestModuleDescriptorFactory")) continue;
            newRestIndex = i;
        }
        if (oldRestIndex == -1 || newRestIndex == -1) {
            return;
        }
        boolean bl = isNewRestFirst = newRestIndex < oldRestIndex;
        if (!isNewRestFirst) {
            Object oldFactory = services[oldRestIndex];
            services[oldRestIndex] = services[newRestIndex];
            services[newRestIndex] = oldFactory;
        }
    }
}

