package com.atlassian.plugin.osgi.hook.rest;

import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.hook.dmz.PluginTypeDetector;
import com.atlassian.plugin.osgi.internal.hook.rest.JaxRsFilterFactory;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.hooks.resolver.ResolverHookFactory;
import org.osgi.framework.wiring.BundleRevision;

import java.util.Collection;

import static java.util.Objects.requireNonNull;

public class RestVersionResolverHookFactory implements ResolverHookFactory {

    private final PackageScannerConfiguration config;
    public RestVersionResolverHookFactory(PackageScannerConfiguration packageScannerConfig) {
        this.config = requireNonNull(packageScannerConfig, "Configuration required.");
    }


    @Override
    public ResolverHook begin(Collection<BundleRevision> collection) {
        PluginTypeDetector pluginTypeDetector = PluginTypeDetector.getInstance(config.getApplicationBundledInternalPlugins());
        return new RestVersionResolverHook(new JaxRsFilterFactory(pluginTypeDetector));
    }

}
