/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hook;

import com.atlassian.plugin.osgi.hook.InternalPluginDetector;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.Bundle;
import org.osgi.framework.hooks.resolver.ResolverHook;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DmzResolverHook
implements ResolverHook {
    private static final Logger LOG = LoggerFactory.getLogger(DmzResolverHook.class);
    static final String ATTR_WIRING_PACKAGE = "osgi.wiring.package";
    private final InternalPluginDetector pluginDetector;

    public DmzResolverHook(Set<String> bundledPluginKeys, Set<String> publicPackages, Set<String> publicPackagesExcludes) {
        this.pluginDetector = new InternalPluginDetector(bundledPluginKeys, publicPackages, publicPackagesExcludes);
    }

    public void filterMatches(BundleRequirement requirement, Collection<BundleCapability> possibleExports) {
        Bundle importingPlugin = requirement.getRevision().getBundle();
        boolean isExternalPlugin = !this.pluginDetector.isInternalPlugin(importingPlugin);
        String pluginKey = this.pluginDetector.getPluginKeyOrSymbolicName(importingPlugin);
        if (isExternalPlugin) {
            LOG.debug("Plugin is external, will try to modify the possible exports. PluginKey: {}", (Object)pluginKey);
            Iterator<BundleCapability> possibleExportsItr = possibleExports.iterator();
            while (possibleExportsItr.hasNext()) {
                BundleCapability bundleCapability = possibleExportsItr.next();
                Object bundleCapabilityPackage = bundleCapability.getAttributes().get(ATTR_WIRING_PACKAGE);
                if (this.pluginDetector.isInternalCapability(bundleCapability)) {
                    possibleExportsItr.remove();
                    LOG.warn("Removed candidate from possible exports. PluginKey: {}. Removed candidate: {}", (Object)pluginKey, bundleCapabilityPackage);
                    continue;
                }
                LOG.debug("Not internal capability. PluginKey: {}. Candidate: {}", (Object)pluginKey, bundleCapabilityPackage);
            }
        } else {
            LOG.debug("Plugin is internal, won't be modifying the possible exports. PluginKey: {}", (Object)pluginKey);
        }
    }

    public void end() {
    }

    public void filterResolvable(Collection<BundleRevision> candidates) {
    }

    public void filterSingletonCollisions(BundleCapability singleton, Collection<BundleCapability> collisions) {
    }
}

