/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.factories.AbstractPluginFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiBundlePlugin;
import com.atlassian.plugin.osgi.factory.OsgiChainedModuleDescriptorFactoryCreator;
import com.atlassian.plugin.osgi.factory.OsgiPluginXmlDescriptorParserFactory;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.parsers.XmlDescriptorParserUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.dom4j.Element;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OsgiBundleFactory
extends AbstractPluginFactory {
    private static final Logger log = LoggerFactory.getLogger(OsgiBundleFactory.class);
    private final OsgiContainerManager osgiContainerManager;
    private final String pluginDescriptorFileName;
    private final OsgiChainedModuleDescriptorFactoryCreator osgiChainedModuleDescriptorFactoryCreator;

    public OsgiBundleFactory(OsgiContainerManager osgi) {
        this("atlassian-plugin.xml", osgi);
    }

    public OsgiBundleFactory(String pluginDescriptorFileName, OsgiContainerManager osgi) {
        super((DescriptorParserFactory)new OsgiPluginXmlDescriptorParserFactory(), (Set)ImmutableSet.of());
        this.pluginDescriptorFileName = (String)Preconditions.checkNotNull((Object)pluginDescriptorFileName);
        this.osgiContainerManager = (OsgiContainerManager)Preconditions.checkNotNull((Object)osgi, (Object)"The osgi container is required");
        this.osgiChainedModuleDescriptorFactoryCreator = new OsgiChainedModuleDescriptorFactoryCreator(new OsgiChainedModuleDescriptorFactoryCreator.ServiceTrackerFactory(){

            @Override
            public ServiceTracker create(String className) {
                return OsgiBundleFactory.this.osgiContainerManager.getServiceTracker(className);
            }
        });
    }

    protected InputStream getDescriptorInputStream(PluginArtifact pluginArtifact) {
        return pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
    }

    protected Predicate<Integer> isValidPluginsVersion() {
        return new Predicate<Integer>(){

            public boolean apply(Integer input) {
                return input != null && input >= 2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        InputStream descriptorStream;
        block4: {
            block5: {
                String string;
                Preconditions.checkNotNull((Object)pluginArtifact, (Object)"The plugin artifact is required");
                descriptorStream = null;
                try {
                    descriptorStream = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
                    if (null != descriptorStream) break block4;
                    Manifest manifest = OsgiHeaderUtil.getManifest(pluginArtifact);
                    if (null == manifest || null == manifest.getMainAttributes().getValue("Bundle-SymbolicName")) break block5;
                    string = OsgiHeaderUtil.getPluginKey(manifest);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(descriptorStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)descriptorStream);
                return string;
            }
            String string = null;
            IOUtils.closeQuietly((InputStream)descriptorStream);
            return string;
        }
        String string = null;
        IOUtils.closeQuietly((InputStream)descriptorStream);
        return string;
    }

    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) {
        Preconditions.checkNotNull((Object)pluginArtifact, (Object)"The plugin artifact is required");
        Preconditions.checkNotNull((Object)moduleDescriptorFactory, (Object)"The module descriptor factory is required");
        String pluginKey = this.canCreate(pluginArtifact);
        if (null == pluginKey) {
            log.warn("Unable to load plugin from '{}'", (Object)pluginArtifact);
            return new UnloadablePlugin("PluginArtifact has no manifest or is not a bundle: '" + pluginArtifact + "'");
        }
        return new OsgiBundlePlugin(this.osgiContainerManager, pluginKey, pluginArtifact);
    }

    public ModuleDescriptor<?> createModule(Plugin plugin, Element module, ModuleDescriptorFactory moduleDescriptorFactory) {
        if (plugin instanceof OsgiBundlePlugin) {
            ModuleDescriptorFactory combinedFactory = this.osgiChainedModuleDescriptorFactoryCreator.create(new OsgiChainedModuleDescriptorFactoryCreator.ResourceLocator(){

                @Override
                public boolean doesResourceExist(String name) {
                    return false;
                }
            }, moduleDescriptorFactory);
            return XmlDescriptorParserUtils.addModule((ModuleDescriptorFactory)combinedFactory, (Plugin)plugin, (Element)module);
        }
        return null;
    }
}

