/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginPermission;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.impl.AbstractPlugin;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.util.BundleClassLoaderAccessor;
import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import com.atlassian.plugin.util.resource.AlternativeDirectoryResourceLoader;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiBundlePlugin
extends AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(OsgiBundlePlugin.class);
    private final SynchronousBundleListener bundleStartStopListener = new SynchronousBundleListener(){

        public void bundleChanged(BundleEvent bundleEvent) {
            if (bundleEvent.getBundle() == OsgiBundlePlugin.this.bundle) {
                if (bundleEvent.getType() == 256) {
                    OsgiBundlePlugin.this.setPluginState(PluginState.DISABLED);
                } else if (bundleEvent.getType() == 2) {
                    OsgiBundlePlugin.this.setPluginState(PluginState.ENABLED);
                }
            }
        }
    };
    private final Date dateLoaded = new Date();
    private OsgiContainerManager osgiContainerManager;
    private Bundle bundle;
    private ClassLoader bundleClassLoader;

    private OsgiBundlePlugin(String pluginKey, PluginArtifact pluginArtifact) {
        super((PluginArtifact)Preconditions.checkNotNull((Object)pluginArtifact));
        this.setPluginsVersion(2);
        this.setKey(pluginKey);
        this.setSystemPlugin(false);
    }

    @Deprecated
    public OsgiBundlePlugin(Bundle bundle, String pluginKey, PluginArtifact pluginArtifact) {
        this(pluginKey, pluginArtifact);
        this.bundle = (Bundle)Preconditions.checkNotNull((Object)bundle);
        this.bundleClassLoader = BundleClassLoaderAccessor.getClassLoader(bundle, (AlternativeResourceLoader)new AlternativeDirectoryResourceLoader());
        PluginInformation pluginInformation = new PluginInformation();
        pluginInformation.setDescription((String)bundle.getHeaders().get("Bundle-Description"));
        pluginInformation.setVersion((String)bundle.getHeaders().get("Bundle-Version"));
        pluginInformation.setVendorName((String)bundle.getHeaders().get("Bundle-Vendor"));
        pluginInformation.setPermissions((Set)ImmutableSet.of((Object)PluginPermission.EXECUTE_JAVA));
        this.setPluginInformation(pluginInformation);
        this.setName((String)bundle.getHeaders().get("Bundle-Name"));
        this.setSystemPlugin(false);
    }

    public OsgiBundlePlugin(OsgiContainerManager osgiContainerManager, String pluginKey, PluginArtifact pluginArtifact) {
        this(pluginKey, pluginArtifact);
        this.osgiContainerManager = (OsgiContainerManager)Preconditions.checkNotNull((Object)osgiContainerManager);
        Manifest manifest = OsgiHeaderUtil.getManifest(pluginArtifact);
        if (null != manifest) {
            this.setName(OsgiHeaderUtil.getAttributeWithoutValidation(manifest, "Bundle-Name"));
            this.setPluginInformation(OsgiHeaderUtil.extractOsgiPluginInformation(manifest, false));
        }
    }

    public Date getDateLoaded() {
        return this.dateLoaded;
    }

    public Date getDateInstalled() {
        long date = this.getPluginArtifact().toFile().lastModified();
        if (date == 0L) {
            date = this.getDateLoaded().getTime();
        }
        return new Date(date);
    }

    public boolean isUninstallable() {
        return true;
    }

    public boolean isDeleteable() {
        return true;
    }

    public boolean isDynamicallyLoaded() {
        return true;
    }

    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        return BundleClassLoaderAccessor.loadClass(this.getBundleOrFail(), clazz);
    }

    public URL getResource(String name) {
        return this.getBundleClassLoaderOrFail().getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.getBundleClassLoaderOrFail().getResourceAsStream(name);
    }

    protected void installInternal() throws OsgiContainerException, IllegalPluginStateException {
        super.installInternal();
        if (null != this.osgiContainerManager) {
            File file = this.pluginArtifact.toFile();
            this.bundle = this.osgiContainerManager.installBundle(file, this.pluginArtifact.getReferenceMode());
            this.bundleClassLoader = BundleClassLoaderAccessor.getClassLoader(this.bundle, (AlternativeResourceLoader)new AlternativeDirectoryResourceLoader());
            this.osgiContainerManager = null;
        } else if (null == this.bundle) {
            throw new IllegalPluginStateException("Cannot reuse instance for bundle '" + this.getKey() + "'");
        }
    }

    protected void uninstallInternal() {
        try {
            if (this.bundleIsUsable("uninstall")) {
                if (this.bundle.getState() != 1) {
                    this.bundle.uninstall();
                } else {
                    log.warn("Bundle '{}' already UNINSTALLED, but still held", (Object)this.getKey());
                }
                this.bundle = null;
                this.bundleClassLoader = null;
            }
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    protected PluginState enableInternal() {
        log.debug("Enabling OSGi bundled plugin '{}'", (Object)this.getKey());
        try {
            if (this.bundleIsUsable("enable")) {
                if (this.bundle.getHeaders().get("Fragment-Host") == null) {
                    log.debug("Plugin '{}' bundle is NOT a fragment, starting.", (Object)this.getKey());
                    this.bundle.start();
                    this.bundle.getBundleContext().addBundleListener((BundleListener)this.bundleStartStopListener);
                } else {
                    log.debug("Plugin '{}' bundle is a fragment, not doing anything.", (Object)this.getKey());
                }
            }
            return PluginState.ENABLED;
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    protected void disableInternal() {
        try {
            if (this.bundleIsUsable("disable")) {
                if (this.bundle.getState() == 32) {
                    this.bundle.stop();
                } else {
                    log.warn("Cannot disable Bundle '{}', not ACTIVE", (Object)this.getKey());
                }
            }
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.getBundleClassLoaderOrFail();
    }

    private String getInstallationStateExplanation() {
        return null != this.osgiContainerManager ? "not yet installed" : "already uninstalled";
    }

    private boolean bundleIsUsable(String task) {
        if (null != this.bundle) {
            return true;
        }
        String why = this.getInstallationStateExplanation();
        log.warn("Cannot {} {} bundle '{}'", new Object[]{task, why, this.getKey()});
        return false;
    }

    private <T> T getOrFail(T what, String name) throws PluginException {
        if (null == what) {
            throw new IllegalPluginStateException("Cannot use " + name + " of " + this.getInstallationStateExplanation() + " '" + this.getKey() + "' from '" + this.pluginArtifact + "'");
        }
        return what;
    }

    private Bundle getBundleOrFail() throws PluginException {
        return this.getOrFail(this.bundle, "bundle");
    }

    private ClassLoader getBundleClassLoaderOrFail() throws PluginException {
        return this.getOrFail(this.bundleClassLoader, "bundleClassLoader");
    }
}

