/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.stage;

import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.TransformContext;
import com.atlassian.plugin.osgi.factory.transform.TransformStage;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.util.ClassLoaderUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.XPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanDescriptorForHostClassesStage
implements TransformStage {
    private static final Logger log = LoggerFactory.getLogger(ScanDescriptorForHostClassesStage.class);

    @Override
    public void execute(TransformContext context) throws PluginTransformationException {
        XPath xpath = DocumentHelper.createXPath((String)"//@class");
        List attributes = xpath.selectNodes((Object)context.getDescriptorDocument());
        for (Attribute attr : attributes) {
            String className = attr.getValue();
            this.scanForHostComponents(context, className);
            int dotpos = className.lastIndexOf(".");
            if (dotpos <= -1) continue;
            String pkg = className.substring(0, dotpos);
            String pkgPath = pkg.replace('.', '/') + '/';
            if (!context.getSystemExports().isExported(pkg)) continue;
            if (context.getPluginArtifact().doesResourceExist(pkgPath)) {
                log.warn("The plugin '" + context.getPluginArtifact().toString() + "' uses a package '" + pkg + "' that is also exported by the application.  It is highly recommended that the " + "plugin use its own packages.");
                continue;
            }
            context.getExtraImports().add(pkg);
        }
    }

    private void scanForHostComponents(TransformContext context, String className) {
        Class cls;
        if (className != null && className.indexOf(":") != -1) {
            return;
        }
        HashMap hostComponentInterfaces = new HashMap();
        for (HostComponentRegistration registration : context.getHostComponentRegistrations()) {
            for (Class<?> cls2 : registration.getMainInterfaceClasses()) {
                hostComponentInterfaces.put(cls2, registration);
            }
        }
        try {
            cls = ClassLoaderUtils.loadClass((String)className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        for (Constructor<?> constructor : cls.getConstructors()) {
            for (Class<?> ctorParam : constructor.getParameterTypes()) {
                if (!hostComponentInterfaces.containsKey(ctorParam)) continue;
                context.addRequiredHostComponent((HostComponentRegistration)hostComponentInterfaces.get(ctorParam));
            }
        }
        for (Executable executable : cls.getMethods()) {
            if (!((Method)executable).getName().startsWith("set") || ((Method)executable).getParameterTypes().length != 1 || !hostComponentInterfaces.containsKey(((Method)executable).getParameterTypes()[0])) continue;
            context.addRequiredHostComponent((HostComponentRegistration)hostComponentInterfaces.get(((Method)executable).getParameterTypes()[0]));
        }
    }
}

