/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.IllegalPluginStateException;
import com.atlassian.plugin.InstallationMode;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginContainerFailedEvent;
import com.atlassian.plugin.event.events.PluginContainerRefreshedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.impl.AbstractPlugin;
import com.atlassian.plugin.module.ContainerAccessor;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.osgi.container.OsgiContainerException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitEndedEvent;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitStartingEvent;
import com.atlassian.plugin.osgi.event.PluginServiceDependencyWaitTimedOutEvent;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.factory.ModuleDescriptorServiceTrackerCustomizer;
import com.atlassian.plugin.osgi.factory.OsgiPluginHelper;
import com.atlassian.plugin.osgi.factory.OsgiPluginInstalledHelper;
import com.atlassian.plugin.osgi.factory.OsgiPluginUninstalledHelper;
import com.atlassian.plugin.osgi.factory.UnrecognizedModuleDescriptorServiceTrackerCustomizer;
import com.atlassian.plugin.util.PluginUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.dom4j.Element;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiPlugin
extends AbstractPlugin
implements AutowireCapablePlugin,
ContainerManagedPlugin {
    public static final String ATLASSIAN_PLUGIN_KEY = "Atlassian-Plugin-Key";
    public static final String REMOTE_PLUGIN_KEY = "Remote-Plugin";
    private final Map<String, Element> moduleElements = new HashMap<String, Element>();
    private final PluginEventManager pluginEventManager;
    private final PackageAdmin packageAdmin;
    private final Set<OutstandingDependency> outstandingDependencies = new CopyOnWriteArraySet<OutstandingDependency>();
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final BundleListener bundleStartStopListener;
    private final PluginArtifact originalPluginArtifact;
    private volatile boolean treatPluginContainerCreationAsRefresh = false;
    private volatile OsgiPluginHelper helper;
    private volatile boolean frameworkStarted = false;

    public OsgiPlugin(String key, OsgiContainerManager mgr, PluginArtifact artifact, PluginArtifact originalPluginArtifact, PluginEventManager pluginEventManager) {
        this.originalPluginArtifact = (PluginArtifact)Preconditions.checkNotNull((Object)originalPluginArtifact);
        this.pluginEventManager = (PluginEventManager)Preconditions.checkNotNull((Object)pluginEventManager);
        this.helper = new OsgiPluginUninstalledHelper((String)Preconditions.checkNotNull((Object)key, (Object)"The plugin key is required"), (OsgiContainerManager)Preconditions.checkNotNull((Object)mgr, (Object)"The osgi container is required"), (PluginArtifact)Preconditions.checkNotNull((Object)artifact, (Object)"The plugin artifact is required"));
        this.packageAdmin = this.extractPackageAdminFromOsgi(mgr);
        this.bundleStartStopListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                if (bundleEvent.getBundle() == OsgiPlugin.this.getBundle()) {
                    if (bundleEvent.getType() == 256) {
                        OsgiPlugin.this.helper.onDisable();
                        OsgiPlugin.this.setPluginState(PluginState.DISABLED);
                    } else if (bundleEvent.getType() == 2) {
                        BundleContext ctx = OsgiPlugin.this.getBundle().getBundleContext();
                        OsgiPlugin.this.helper.onEnable(OsgiPlugin.this.createServiceTrackers(ctx));
                        OsgiPlugin.this.setPluginState(PluginState.ENABLED);
                    }
                }
            }
        };
    }

    @VisibleForTesting
    OsgiPlugin(PluginEventManager pluginEventManager, OsgiPluginHelper helper) {
        this.helper = helper;
        this.pluginEventManager = pluginEventManager;
        this.packageAdmin = null;
        this.bundleStartStopListener = null;
        this.originalPluginArtifact = null;
    }

    public Bundle getBundle() throws IllegalPluginStateException {
        return this.helper.getBundle();
    }

    public InstallationMode getInstallationMode() {
        return this.helper.isRemotePlugin() ? InstallationMode.REMOTE : InstallationMode.LOCAL;
    }

    public boolean isUninstallable() {
        return true;
    }

    public boolean isDynamicallyLoaded() {
        return true;
    }

    public boolean isDeleteable() {
        return true;
    }

    public Date getDateInstalled() {
        long date = this.getPluginArtifact().toFile().lastModified();
        if (date == 0L) {
            date = this.getDateLoaded().getTime();
        }
        return new Date(date);
    }

    public PluginArtifact getPluginArtifact() {
        return this.originalPluginArtifact;
    }

    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException, IllegalPluginStateException {
        return this.helper.loadClass(clazz, callingClass);
    }

    public URL getResource(String name) throws IllegalPluginStateException {
        return this.helper.getResource(name);
    }

    public InputStream getResourceAsStream(String name) throws IllegalPluginStateException {
        return this.helper.getResourceAsStream(name);
    }

    public ClassLoader getClassLoader() throws IllegalPluginStateException {
        return this.helper.getClassLoader();
    }

    @PluginEventListener
    public void onPluginContainerFailed(PluginContainerFailedEvent event) throws IllegalPluginStateException {
        if (this.getKey() == null) {
            throw new IllegalPluginStateException("Plugin key must be set");
        }
        if (this.getKey().equals(event.getPluginKey())) {
            this.logAndClearOustandingDependencies();
            this.getLog().error("Unable to start the plugin container for plugin " + this.getKey(), event.getCause());
            this.setPluginState(PluginState.DISABLED);
        }
    }

    @PluginEventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        this.frameworkStarted = true;
    }

    @PluginEventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        this.frameworkStarted = false;
    }

    @PluginEventListener
    public void onServiceDependencyWaitStarting(PluginServiceDependencyWaitStartingEvent event) {
        if (event.getPluginKey() != null && event.getPluginKey().equals(this.getKey())) {
            OutstandingDependency dep = new OutstandingDependency(event.getBeanName(), String.valueOf(event.getFilter()));
            this.outstandingDependencies.add(dep);
            this.getLog().info(this.generateOutstandingDependencyLogMessage(dep, "Waiting for"));
        }
    }

    @PluginEventListener
    public void onServiceDependencyWaitEnded(PluginServiceDependencyWaitEndedEvent event) {
        if (event.getPluginKey() != null && event.getPluginKey().equals(this.getKey())) {
            OutstandingDependency dep = new OutstandingDependency(event.getBeanName(), String.valueOf(event.getFilter()));
            this.outstandingDependencies.remove(dep);
            this.getLog().info(this.generateOutstandingDependencyLogMessage(dep, "Found"));
        }
    }

    @PluginEventListener
    public void onServiceDependencyWaitEnded(PluginServiceDependencyWaitTimedOutEvent event) {
        if (event.getPluginKey() != null && event.getPluginKey().equals(this.getKey())) {
            OutstandingDependency dep = new OutstandingDependency(event.getBeanName(), String.valueOf(event.getFilter()));
            this.outstandingDependencies.remove(dep);
            this.getLog().error(this.generateOutstandingDependencyLogMessage(dep, "Timeout waiting for "));
        }
    }

    private String generateOutstandingDependencyLogMessage(OutstandingDependency dep, String action) {
        StringBuilder sb = new StringBuilder();
        sb.append(action).append(" ");
        sb.append("service '").append(dep.getBeanName()).append("' for plugin '").append(this.getKey()).append("' with filter ").append(dep.getFilter());
        return sb.toString();
    }

    @PluginEventListener
    public void onPluginContainerRefresh(PluginContainerRefreshedEvent event) throws IllegalPluginStateException {
        if (this.getKey() == null) {
            throw new IllegalPluginStateException("Plugin key must be set");
        }
        if (this.getKey().equals(event.getPluginKey())) {
            this.outstandingDependencies.clear();
            this.helper.setPluginContainer(event.getContainer());
            if (!this.compareAndSetPluginState(PluginState.ENABLING, PluginState.ENABLED) && this.getPluginState() != PluginState.ENABLED) {
                this.log.warn("Ignoring the bean container that was just created for plugin " + this.getKey() + ".  The plugin " + "is in an invalid state, " + this.getPluginState() + ", that doesn't support a transition to " + "enabled.  Most likely, it was disabled due to a timeout.");
                this.helper.setPluginContainer(null);
                return;
            }
            if (this.treatPluginContainerCreationAsRefresh) {
                this.pluginEventManager.broadcast((Object)new PluginRefreshedEvent((Plugin)this));
            } else {
                this.treatPluginContainerCreationAsRefresh = true;
            }
        }
    }

    public <T> T autowire(Class<T> clazz) throws IllegalPluginStateException {
        return this.autowire(clazz, AutowireCapablePlugin.AutowireStrategy.AUTOWIRE_AUTODETECT);
    }

    public <T> T autowire(Class<T> clazz, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalPluginStateException {
        return (T)this.helper.getRequiredContainerAccessor().createBean(clazz);
    }

    public void autowire(Object instance) throws IllegalStateException {
        this.autowire(instance, AutowireCapablePlugin.AutowireStrategy.AUTOWIRE_AUTODETECT);
    }

    public void autowire(Object instance, AutowireCapablePlugin.AutowireStrategy autowireStrategy) throws IllegalPluginStateException {
        this.helper.getRequiredContainerAccessor().injectBean(instance);
    }

    public Set<String> getRequiredPlugins() throws IllegalPluginStateException {
        return this.helper.getRequiredPlugins();
    }

    public String toString() {
        return this.getKey();
    }

    protected void installInternal() throws IllegalPluginStateException {
        this.log.debug("Installing OSGi plugin '{}'", (Object)this.getKey());
        Bundle bundle = this.helper.install();
        this.helper = new OsgiPluginInstalledHelper(bundle, this.packageAdmin);
    }

    protected synchronized PluginState enableInternal() throws OsgiContainerException, IllegalPluginStateException {
        this.log.debug("Enabling OSGi plugin '{}'", (Object)this.getKey());
        try {
            PluginState stateResult;
            if (this.getBundle().getState() == 32) {
                this.log.debug("Plugin '{}' bundle is already active, not doing anything", (Object)this.getKey());
                stateResult = PluginState.ENABLED;
            } else if (this.getBundle().getState() == 4 || this.getBundle().getState() == 2) {
                this.pluginEventManager.register((Object)this);
                if (!this.treatPluginContainerCreationAsRefresh) {
                    stateResult = PluginState.ENABLING;
                    this.setPluginState(stateResult);
                } else {
                    stateResult = PluginState.ENABLED;
                }
                this.log.debug("Plugin '{}' bundle is resolved or installed, starting.", (Object)this.getKey());
                this.getBundle().start();
                BundleContext ctx = this.getBundle().getBundleContext();
                this.helper.onEnable(this.createServiceTrackers(ctx));
                ctx.addBundleListener(this.bundleStartStopListener);
            } else {
                throw new OsgiContainerException("Cannot enable the plugin '" + this.getKey() + "' when the bundle is not in the resolved or installed state: " + this.getBundle().getState() + "(" + this.getBundle().getBundleId() + ")");
            }
            return this.getPluginState() != PluginState.ENABLED ? stateResult : PluginState.ENABLED;
        }
        catch (BundleException e) {
            this.log.error("Detected an error (BundleException) enabling the plugin '" + this.getKey() + "' : " + e.getMessage() + ". " + " This error usually occurs when your plugin imports a package from another bundle with a specific version constraint " + "and either the bundle providing that package doesn't meet those version constraints, or there is no bundle " + "available that provides the specified package. For more details on how to fix this, see " + "https://developer.atlassian.com/x/mQAN");
            throw new OsgiContainerException("Cannot start plugin: " + this.getKey(), e);
        }
    }

    private ServiceTracker[] createServiceTrackers(BundleContext ctx) {
        return new ServiceTracker[]{new ServiceTracker(ctx, ModuleDescriptor.class.getName(), (ServiceTrackerCustomizer)new ModuleDescriptorServiceTrackerCustomizer(this, this.pluginEventManager)), new ServiceTracker(ctx, ListableModuleDescriptorFactory.class.getName(), (ServiceTrackerCustomizer)new UnrecognizedModuleDescriptorServiceTrackerCustomizer(this, this.pluginEventManager))};
    }

    protected synchronized void disableInternal() throws OsgiContainerException, IllegalPluginStateException {
        if (!this.requiresRestart()) {
            try {
                if (this.getPluginState() == PluginState.DISABLING) {
                    this.logAndClearOustandingDependencies();
                }
                this.helper.onDisable();
                this.pluginEventManager.unregister((Object)this);
                this.getBundle().stop();
                this.treatPluginContainerCreationAsRefresh = false;
            }
            catch (BundleException e) {
                this.log.error("Detected an error (BundleException) disabling the plugin '" + this.getKey() + "' : " + e.getMessage() + ".");
                throw new OsgiContainerException("Cannot stop plugin: " + this.getKey(), e);
            }
        }
    }

    private boolean requiresRestart() {
        return this.frameworkStarted && PluginUtils.doesPluginRequireRestart((Plugin)this);
    }

    private void logAndClearOustandingDependencies() {
        for (OutstandingDependency dep : this.outstandingDependencies) {
            this.getLog().error(this.generateOutstandingDependencyLogMessage(dep, "Never resolved"));
        }
        this.outstandingDependencies.clear();
    }

    protected void uninstallInternal() throws OsgiContainerException, IllegalPluginStateException {
        int retryCount = 0;
        BundleException rootCause = null;
        long sleepTime = 500L;
        while (true) {
            try {
                if (this.getBundle().getState() != 1) {
                    this.pluginEventManager.unregister((Object)this);
                    this.getBundle().uninstall();
                    this.helper.onUninstall();
                    this.setPluginState(PluginState.UNINSTALLED);
                    break;
                }
                this.log.debug("Trying to uninstall '{}', but this has already been uninstalled", (Object)this.getKey());
                this.pluginEventManager.unregister((Object)this);
            }
            catch (BundleException e) {
                BundleException bundleException = rootCause = retryCount == 0 ? e : rootCause;
                if (++retryCount < 3) {
                    this.log.debug("Try {} will Retry again in  {} mSecs", (Object)retryCount, (Object)500L);
                    this.log.debug(e.getMessage(), (Throwable)e);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e1) {
                        throw new OsgiContainerException("Cannot uninstall bundle, as thread was interrupted");
                    }
                    continue;
                }
                this.log.error("Detected an error (BundleException) disabling the plugin '{}'.", (Object)this.getKey());
                this.log.error(rootCause.getMessage(), (Throwable)rootCause);
                throw new OsgiContainerException("Cannot uninstall bundle " + this.getBundle().getSymbolicName());
            }
            break;
        }
    }

    void addModuleDescriptorElement(String key, Element element) {
        this.moduleElements.put(key, element);
    }

    void clearModuleDescriptor(String key) {
        this.removeModuleDescriptor(key);
    }

    Map<String, Element> getModuleElements() {
        return this.moduleElements;
    }

    private PackageAdmin extractPackageAdminFromOsgi(OsgiContainerManager mgr) {
        Bundle bundle = mgr.getBundles()[0];
        ServiceReference ref = bundle.getBundleContext().getServiceReference(PackageAdmin.class.getName());
        return (PackageAdmin)bundle.getBundleContext().getService(ref);
    }

    public ContainerAccessor getContainerAccessor() {
        return this.helper.getContainerAccessor();
    }

    private static class OutstandingDependency {
        private final String beanName;
        private final String filter;

        public OutstandingDependency(String beanName, String filter) {
            this.beanName = beanName;
            this.filter = filter;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public String getFilter() {
            return this.filter;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OutstandingDependency that = (OutstandingDependency)o;
            if (this.beanName != null ? !this.beanName.equals(that.beanName) : that.beanName != null) {
                return false;
            }
            return this.filter.equals(that.filter);
        }

        public int hashCode() {
            int result = this.beanName != null ? this.beanName.hashCode() : 0;
            result = 31 * result + this.filter.hashCode();
            return result;
        }
    }
}

