/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.factory.OsgiChainedModuleDescriptorFactoryCreator;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.osgi.factory.OsgiPluginXmlDescriptorParserFactory;
import com.atlassian.plugin.osgi.factory.transform.DefaultPluginTransformer;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformer;
import com.atlassian.plugin.osgi.factory.transform.model.SystemExports;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiPluginFactory
implements PluginFactory {
    private static final Logger log = LoggerFactory.getLogger(OsgiPluginFactory.class);
    private final OsgiContainerManager osgi;
    private final String pluginDescriptorFileName;
    private final DescriptorParserFactory descriptorParserFactory;
    private final PluginEventManager pluginEventManager;
    private final Set<String> applicationKeys;
    private final OsgiPersistentCache persistentCache;
    private final PluginTransformerFactory pluginTransformerFactory;
    private volatile PluginTransformer pluginTransformer;
    private ServiceTracker moduleDescriptorFactoryTracker;
    private final OsgiChainedModuleDescriptorFactoryCreator osgiChainedModuleDescriptorFactoryCreator;

    public OsgiPluginFactory(String pluginDescriptorFileName, String applicationKey, OsgiPersistentCache persistentCache, OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        this(pluginDescriptorFileName, new HashSet<String>(Arrays.asList(applicationKey)), persistentCache, osgi, pluginEventManager);
    }

    public OsgiPluginFactory(String pluginDescriptorFileName, Set<String> applicationKeys, OsgiPersistentCache persistentCache, OsgiContainerManager osgi, PluginEventManager pluginEventManager) {
        this(pluginDescriptorFileName, applicationKeys, persistentCache, osgi, pluginEventManager, new DefaultPluginTransformerFactory());
    }

    public OsgiPluginFactory(String pluginDescriptorFileName, Set<String> applicationKeys, OsgiPersistentCache persistentCache, final OsgiContainerManager osgi, PluginEventManager pluginEventManager, PluginTransformerFactory pluginTransformerFactory) {
        Validate.notNull((Object)pluginDescriptorFileName, (String)"Plugin descriptor is required");
        Validate.notNull((Object)osgi, (String)"The OSGi container is required");
        Validate.notNull(applicationKeys, (String)"The application keys are required");
        Validate.notNull((Object)persistentCache, (String)"The osgi persistent cache is required");
        Validate.notNull((Object)persistentCache, (String)"The plugin event manager is required");
        Validate.notNull((Object)pluginTransformerFactory, (String)"The plugin transformer factory is required");
        this.osgi = osgi;
        this.pluginDescriptorFileName = pluginDescriptorFileName;
        this.descriptorParserFactory = new OsgiPluginXmlDescriptorParserFactory();
        this.pluginEventManager = pluginEventManager;
        this.applicationKeys = applicationKeys;
        this.persistentCache = persistentCache;
        this.osgiChainedModuleDescriptorFactoryCreator = new OsgiChainedModuleDescriptorFactoryCreator(new OsgiChainedModuleDescriptorFactoryCreator.ServiceTrackerFactory(){

            public ServiceTracker create(String className) {
                return osgi.getServiceTracker(className);
            }
        });
        this.pluginTransformerFactory = pluginTransformerFactory;
    }

    private PluginTransformer getPluginTransformer() {
        if (this.pluginTransformer == null) {
            String exportString = (String)this.osgi.getBundles()[0].getHeaders().get("Export-Package");
            SystemExports exports = new SystemExports(exportString);
            this.pluginTransformer = this.pluginTransformerFactory.newPluginTransformer(this.persistentCache, exports, this.applicationKeys, this.pluginDescriptorFileName, this.osgi);
        }
        return this.pluginTransformer;
    }

    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact is required");
        String pluginKey = this.getPluginKeyFromDescriptor(pluginArtifact);
        if (pluginKey == null) {
            pluginKey = this.getPluginKeyFromManifest(pluginArtifact);
        }
        return pluginKey;
    }

    private String getPluginKeyFromManifest(PluginArtifact pluginArtifact) {
        Manifest mf = this.getManifest(pluginArtifact);
        if (mf != null) {
            String key = mf.getMainAttributes().getValue("Atlassian-Plugin-Key");
            String version = mf.getMainAttributes().getValue("Bundle-Version");
            if (key != null) {
                if (version != null) {
                    return key;
                }
                log.warn("Found plugin key '" + key + "' in the manifest but no bundle version, so it can't be loaded as an OsgiPlugin");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Manifest getManifest(PluginArtifact pluginArtifact) {
        InputStream descriptorClassStream = pluginArtifact.getResourceAsStream("META-INF/MANIFEST.MF");
        if (descriptorClassStream != null) {
            try {
                Manifest manifest = new Manifest(descriptorClassStream);
                return manifest;
            }
            catch (IOException e) {
                log.error("Cannot read manifest from plugin artifact " + pluginArtifact.getName(), (Throwable)e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)descriptorClassStream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPluginKeyFromDescriptor(PluginArtifact pluginArtifact) {
        String pluginKey = null;
        InputStream descriptorStream = null;
        try {
            DescriptorParser descriptorParser;
            descriptorStream = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
            if (descriptorStream != null && (descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream, this.applicationKeys.toArray(new String[this.applicationKeys.size()]))).getPluginsVersion() == 2) {
                pluginKey = descriptorParser.getKey();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(descriptorStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)descriptorStream);
        return pluginKey;
    }

    public Plugin create(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Validate.notNull((Object)deploymentUnit, (String)"The deployment unit is required");
        return this.create((PluginArtifact)new JarPluginArtifact(deploymentUnit.getPath()), moduleDescriptorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        InputStream pluginDescriptor;
        OsgiPlugin plugin;
        block5: {
            Validate.notNull((Object)pluginArtifact, (String)"The plugin deployment unit is required");
            Validate.notNull((Object)moduleDescriptorFactory, (String)"The module descriptor factory is required");
            plugin = null;
            pluginDescriptor = null;
            try {
                pluginDescriptor = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
                if (pluginDescriptor != null) {
                    ModuleDescriptorFactory combinedFactory = this.getChainedModuleDescriptorFactory(moduleDescriptorFactory, pluginArtifact);
                    DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor, this.applicationKeys.toArray(new String[this.applicationKeys.size()]));
                    OsgiPlugin osgiPlugin = new OsgiPlugin(parser.getKey(), this.osgi, this.createOsgiPluginJar(pluginArtifact), pluginArtifact, this.pluginEventManager);
                    plugin = parser.configurePlugin(combinedFactory, (Plugin)osgiPlugin);
                    break block5;
                }
                Manifest mf = this.getManifest(pluginArtifact);
                String pluginKey = mf.getMainAttributes().getValue("Atlassian-Plugin-Key");
                String pluginVersion = mf.getMainAttributes().getValue("Bundle-Version");
                Validate.notEmpty((String)pluginKey);
                Validate.notEmpty((String)pluginVersion);
                plugin = new OsgiPlugin(pluginKey, this.osgi, pluginArtifact, pluginArtifact, this.pluginEventManager);
                plugin.setKey(pluginKey);
                plugin.setPluginsVersion(2);
                PluginInformation info = new PluginInformation();
                info.setVersion(pluginVersion);
                plugin.setPluginInformation(info);
            }
            catch (PluginTransformationException ex) {
                Plugin plugin2;
                try {
                    plugin2 = this.reportUnloadablePlugin(pluginArtifact.toFile(), ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(pluginDescriptor);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)pluginDescriptor);
                return plugin2;
            }
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }

    private ModuleDescriptorFactory getChainedModuleDescriptorFactory(ModuleDescriptorFactory originalFactory, final PluginArtifact pluginArtifact) {
        return this.osgiChainedModuleDescriptorFactoryCreator.create(new OsgiChainedModuleDescriptorFactoryCreator.ResourceLocator(){

            public boolean doesResourceExist(String name) {
                return pluginArtifact.doesResourceExist(name);
            }
        }, originalFactory);
    }

    private PluginArtifact createOsgiPluginJar(PluginArtifact pluginArtifact) {
        File transformedFile = this.getPluginTransformer().transform(pluginArtifact, this.osgi.getHostComponentRegistrations());
        return new JarPluginArtifact(transformedFile);
    }

    private Plugin reportUnloadablePlugin(File file, Exception e) {
        log.error("Unable to load plugin: " + file, (Throwable)e);
        UnloadablePlugin plugin = new UnloadablePlugin();
        plugin.setErrorText("Unable to load plugin: " + e.getMessage());
        return plugin;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultPluginTransformerFactory
    implements PluginTransformerFactory {
        @Override
        public PluginTransformer newPluginTransformer(OsgiPersistentCache cache, SystemExports systemExports, Set<String> applicationKeys, String pluginDescriptorPath, OsgiContainerManager osgi) {
            return new DefaultPluginTransformer(cache, systemExports, applicationKeys, pluginDescriptorPath, osgi);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PluginTransformerFactory {
        public PluginTransformer newPluginTransformer(OsgiPersistentCache var1, SystemExports var2, Set<String> var3, String var4, OsgiContainerManager var5);
    }
}

