/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform.model;

import com.atlassian.plugin.osgi.util.OsgiHeaderUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SystemExports {
    private final Map<String, Map<String, String>> exports;
    public static final SystemExports NONE = new SystemExports("");

    public SystemExports(String exportsLine) {
        if (exportsLine == null) {
            exportsLine = "";
        }
        this.exports = Collections.unmodifiableMap(OsgiHeaderUtil.parseHeader(exportsLine));
    }

    public String getFullExport(String pkg) {
        if (this.exports.containsKey(pkg)) {
            HashMap<String, String> attrs = new HashMap<String, String>(this.exports.get(pkg));
            if (attrs.containsKey("version")) {
                String version = (String)attrs.get("version");
                attrs.put("version", "[" + version + "," + version + "]");
            }
            return OsgiHeaderUtil.buildHeader(pkg, attrs);
        }
        return pkg;
    }

    public boolean isExported(String pkg) {
        return this.exports.containsKey(pkg);
    }
}

