/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;

public class UnloadableStaticPluginFactory
implements PluginFactory {
    private final String pluginDescriptorFileName;
    private final XmlDescriptorParserFactory descriptorParserFactory;

    public UnloadableStaticPluginFactory(String pluginDescriptorFileName) {
        this.pluginDescriptorFileName = pluginDescriptorFileName;
        this.descriptorParserFactory = new XmlDescriptorParserFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        InputStream descriptorStream;
        block2: {
            String string;
            Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact is required");
            descriptorStream = null;
            try {
                DescriptorParser descriptorParser;
                descriptorStream = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
                if (descriptorStream == null || (descriptorParser = this.descriptorParserFactory.getInstance(descriptorStream, new String[0])).getPluginsVersion() != 1) break block2;
                string = descriptorParser.getKey();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(descriptorStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)descriptorStream);
            return string;
        }
        IOUtils.closeQuietly((InputStream)descriptorStream);
        return null;
    }

    public Plugin create(DeploymentUnit deploymentUnit, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Validate.notNull((Object)deploymentUnit, (String)"The deployment unit is required");
        return this.create((PluginArtifact)new JarPluginArtifact(deploymentUnit.getPath()), moduleDescriptorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Validate.notNull((Object)pluginArtifact, (String)"The plugin deployment unit is required");
        Validate.notNull((Object)moduleDescriptorFactory, (String)"The module descriptor factory is required");
        UnloadablePlugin plugin = null;
        InputStream pluginDescriptor = null;
        try {
            pluginDescriptor = pluginArtifact.getResourceAsStream(this.pluginDescriptorFileName);
            if (pluginDescriptor == null) {
                throw new PluginParseException("No descriptor found in classloader for : " + pluginArtifact);
            }
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor, new String[0]);
            plugin = new UnloadablePlugin();
            try {
                parser.configurePlugin(moduleDescriptorFactory, (Plugin)plugin);
            }
            catch (Exception ex) {
                plugin.setKey(parser.getKey());
            }
            plugin.setErrorText("Unable to load the static '" + pluginArtifact + "' plugin from the plugins directory.  Please " + "copy this file into WEB-INF/lib and restart.");
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(pluginDescriptor);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }
}

