/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory.transform;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.factory.transform.JarUtils;
import com.atlassian.plugin.osgi.factory.transform.PluginTransformationException;
import com.atlassian.plugin.osgi.factory.transform.model.ComponentImport;
import com.atlassian.plugin.osgi.factory.transform.model.SystemExports;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.parsers.XmlDescriptorParser;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.Validate;
import org.dom4j.Document;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransformContext {
    private final Manifest manifest;
    private final List<HostComponentRegistration> regs;
    private final Map<String, byte[]> fileOverrides;
    private final Map<String, String> bndInstructions;
    private final Document descriptorDocument;
    private final List<String> extraImports;
    private final List<String> extraExports;
    private final Set<String> bundleClassPathJars;
    private final PluginArtifact pluginArtifact;
    private final Map<String, ComponentImport> componentImports;
    private final SystemExports systemExports;
    private final Set<String> applicationKeys;
    private boolean shouldRequireSpring = false;
    private final OsgiContainerManager osgiContainerManager;
    private final Set<HostComponentRegistration> requiredHostComponents;
    private final Map<String, String> beanSourceMap = new HashMap<String, String>();

    public TransformContext(List<HostComponentRegistration> regs, SystemExports systemExports, PluginArtifact pluginArtifact, Set<String> applicationKeys, String descriptorPath, OsgiContainerManager osgiContainerManager) {
        this.osgiContainerManager = osgiContainerManager;
        Validate.notNull((Object)pluginArtifact, (String)"The plugin artifact must be specified");
        Validate.notNull((Object)descriptorPath, (String)"The plugin descriptor path must be specified");
        Validate.notNull((Object)systemExports, (String)"The system exports must be specified");
        this.regs = regs;
        this.systemExports = systemExports;
        this.pluginArtifact = pluginArtifact;
        this.applicationKeys = applicationKeys == null ? Collections.emptySet() : applicationKeys;
        this.manifest = JarUtils.getManifest(pluginArtifact.toFile());
        this.fileOverrides = new HashMap<String, byte[]>();
        this.bndInstructions = new HashMap<String, String>();
        this.descriptorDocument = TransformContext.retrieveDocFromJar(pluginArtifact, descriptorPath);
        this.extraImports = new ArrayList<String>();
        this.extraExports = new ArrayList<String>();
        this.bundleClassPathJars = new HashSet<String>();
        this.componentImports = TransformContext.parseComponentImports(this.descriptorDocument);
        this.requiredHostComponents = new HashSet<HostComponentRegistration>();
    }

    public File getPluginFile() {
        return this.pluginArtifact.toFile();
    }

    public PluginArtifact getPluginArtifact() {
        return this.pluginArtifact;
    }

    public List<HostComponentRegistration> getHostComponentRegistrations() {
        return this.regs;
    }

    public Map<String, byte[]> getFileOverrides() {
        return this.fileOverrides;
    }

    public Map<String, String> getBndInstructions() {
        return this.bndInstructions;
    }

    public Document getDescriptorDocument() {
        return this.descriptorDocument;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public List<String> getExtraImports() {
        return this.extraImports;
    }

    public List<String> getExtraExports() {
        return this.extraExports;
    }

    public void addBundleClasspathJar(String classpath) {
        this.bundleClassPathJars.add(classpath);
    }

    public Set<String> getBundleClassPathJars() {
        return Collections.unmodifiableSet(this.bundleClassPathJars);
    }

    public Map<String, ComponentImport> getComponentImports() {
        return this.componentImports;
    }

    public SystemExports getSystemExports() {
        return this.systemExports;
    }

    public Set<String> getApplicationKeys() {
        return this.applicationKeys;
    }

    public boolean shouldRequireSpring() {
        return this.shouldRequireSpring;
    }

    public void setShouldRequireSpring(boolean shouldRequireSpring) {
        this.shouldRequireSpring = shouldRequireSpring;
        if (shouldRequireSpring) {
            this.getFileOverrides().put("META-INF/spring/", new byte[0]);
        }
    }

    public OsgiContainerManager getOsgiContainerManager() {
        return this.osgiContainerManager;
    }

    public Iterable<JarEntry> getPluginJarEntries() {
        return JarUtils.getEntries(this.pluginArtifact.toFile());
    }

    public JarEntry getPluginJarEntry(String path) {
        return JarUtils.getEntry(this.pluginArtifact.toFile(), path);
    }

    public void addRequiredHostComponent(HostComponentRegistration hostComponent) {
        this.requiredHostComponents.add(hostComponent);
    }

    public Set<HostComponentRegistration> getRequiredHostComponents() {
        return this.requiredHostComponents;
    }

    public void trackBean(String name, String source) throws PluginTransformationException {
        Validate.notNull((Object)name, (String)"empty bean name");
        Validate.notNull((Object)source, (String)"source of bean is required");
        if (this.beanSourceMap.containsKey(name)) {
            String message = String.format("The bean identifier '%s' is used by two different beans from %s and %s", name, source, this.beanSourceMap.get(name));
            throw new PluginTransformationException(message);
        }
        this.beanSourceMap.put(name, source);
    }

    public boolean beanExists(String name) {
        return this.beanSourceMap.containsKey(name);
    }

    private static Map<String, ComponentImport> parseComponentImports(Document descriptorDocument) {
        HashMap<String, ComponentImport> componentImports = new HashMap<String, ComponentImport>();
        List elements = descriptorDocument.getRootElement().elements("component-import");
        for (Element component : elements) {
            ComponentImport ci = new ComponentImport(component);
            componentImports.put(ci.getKey(), ci);
        }
        return ImmutableMap.copyOf(componentImports);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document retrieveDocFromJar(PluginArtifact pluginArtifact, String descriptorPath) throws PluginTransformationException {
        InputStream stream = null;
        try {
            stream = pluginArtifact.getResourceAsStream(descriptorPath);
            if (stream == null) {
                throw new PluginTransformationException("Unable to access descriptor " + descriptorPath);
            }
            Document document = new DocumentExposingDescriptorParser(stream).getDocument();
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    private static class DocumentExposingDescriptorParser
    extends XmlDescriptorParser {
        DocumentExposingDescriptorParser(InputStream source) throws PluginParseException {
            super(source, new String[]{null});
        }

        public Document getDocument() {
            return super.getDocument();
        }
    }
}

