/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.hostcomponents.impl;

import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.ContextClassLoaderStrategy;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentRegistration;
import com.atlassian.plugin.osgi.hostcomponents.InstanceBuilder;
import com.atlassian.plugin.osgi.hostcomponents.impl.DefaultInstanceBuilder;
import com.atlassian.plugin.osgi.hostcomponents.impl.Registration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultComponentRegistrar
implements ComponentRegistrar {
    private final List<HostComponentRegistration> registry = new CopyOnWriteArrayList<HostComponentRegistration>();
    private final Log log = LogFactory.getLog(DefaultComponentRegistrar.class);

    @Override
    public InstanceBuilder register(Class<?> ... mainInterfaces) {
        Registration reg = new Registration(mainInterfaces);
        this.registry.add(reg);
        return new DefaultInstanceBuilder(reg);
    }

    public List<ServiceRegistration> writeRegistry(BundleContext ctx) {
        ArrayList<ServiceRegistration> services = new ArrayList<ServiceRegistration>();
        for (HostComponentRegistration reg : new ArrayList<HostComponentRegistration>(this.registry)) {
            ServiceRegistration sreg;
            if (Arrays.asList(reg.getMainInterfaceClasses()).contains(HostContainer.class)) {
                this.log.warn((Object)"Cannot register a HostContainer as a host component, skipping");
                this.registry.remove(reg);
                continue;
            }
            String[] names = reg.getMainInterfaces();
            reg.getProperties().put("plugins-host", Boolean.TRUE.toString());
            String beanName = reg.getProperties().get("bean-name");
            if (beanName == null) {
                String genKey = String.valueOf(((Object)Arrays.asList(reg.getMainInterfaces())).hashCode());
                reg.getProperties().put("bean-name", "hostComponent-" + genKey);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Registering: " + Arrays.asList(names) + " instance " + reg.getInstance() + "with properties: " + reg.getProperties()));
            }
            if (names.length == 0) {
                this.log.warn((Object)("Host component " + beanName + " of instance " + reg.getInstance() + " has no interfaces"));
            }
            Object service = reg.getInstance();
            if (!ContextClassLoaderStrategy.USE_PLUGIN.name().equals(reg.getProperties().get("context-class-loader-strategy"))) {
                service = this.wrapService(reg.getMainInterfaceClasses(), reg.getInstance());
            }
            if ((sreg = ctx.registerService(names, service, reg.getProperties())) == null) continue;
            services.add(sreg);
        }
        return Collections.unmodifiableList(services);
    }

    public List<HostComponentRegistration> getRegistry() {
        return Collections.unmodifiableList(this.registry);
    }

    protected Object wrapService(Class<?>[] interfaces, Object service) {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)new ContextClassLoaderSettingInvocationHandler(service));
    }

    private static class ContextClassLoaderSettingInvocationHandler
    implements InvocationHandler {
        private final Object service;

        ContextClassLoaderSettingInvocationHandler(Object service) {
            this.service = service;
        }

        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            Thread thread = Thread.currentThread();
            ClassLoader ccl = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this.service.getClass().getClassLoader());
                Object object = method.invoke(this.service, objects);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                thread.setContextClassLoader(ccl);
            }
        }
    }
}

