/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnrecognizedModuleDescriptorServiceTrackerCustomizer
implements ServiceTrackerCustomizer {
    private final Bundle bundle;
    private final OsgiPlugin plugin;
    private final Log log = LogFactory.getLog(UnrecognizedModuleDescriptorServiceTrackerCustomizer.class);

    public UnrecognizedModuleDescriptorServiceTrackerCustomizer(OsgiPlugin plugin) {
        Validate.notNull((Object)((Object)plugin));
        this.bundle = plugin.getBundle();
        Validate.notNull((Object)this.bundle);
        this.plugin = plugin;
    }

    public Object addingService(ServiceReference serviceReference) {
        ListableModuleDescriptorFactory factory = (ListableModuleDescriptorFactory)this.bundle.getBundleContext().getService(serviceReference);
        for (UnrecognisedModuleDescriptor unrecognised : this.getModuleDescriptorsByDescriptorClass(UnrecognisedModuleDescriptor.class)) {
            Element source = this.plugin.getModuleElements().get(unrecognised.getKey());
            if (source == null || !factory.hasModuleDescriptor(source.getName())) continue;
            try {
                ModuleDescriptor descriptor = factory.getModuleDescriptor(source.getName());
                descriptor.init(unrecognised.getPlugin(), source);
                this.plugin.addModuleDescriptor(descriptor);
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)("Turned plugin module " + descriptor.getCompleteKey() + " into module " + descriptor));
            }
            catch (Exception e) {
                this.log.error((Object)("Unable to transform " + unrecognised.getCompleteKey() + " into actual plugin module using factory " + factory), (Throwable)e);
                unrecognised.setErrorText(e.getMessage());
            }
        }
        return factory;
    }

    public void modifiedService(ServiceReference serviceReference, Object o) {
        this.removedService(serviceReference, o);
        this.addingService(serviceReference);
    }

    public void removedService(ServiceReference serviceReference, Object o) {
        ListableModuleDescriptorFactory factory = (ListableModuleDescriptorFactory)o;
        for (Class<ModuleDescriptor<?>> moduleDescriptorClass : factory.getModuleDescriptorClasses()) {
            for (ModuleDescriptor<?> descriptor : this.getModuleDescriptorsByDescriptorClass(moduleDescriptorClass)) {
                UnrecognisedModuleDescriptor unrecognisedModuleDescriptor = new UnrecognisedModuleDescriptor();
                Element source = this.plugin.getModuleElements().get(descriptor.getKey());
                if (source == null) continue;
                unrecognisedModuleDescriptor.init((Plugin)this.plugin, source);
                unrecognisedModuleDescriptor.setErrorText("Support for this module is not currently installed.");
                this.plugin.addModuleDescriptor((ModuleDescriptor)unrecognisedModuleDescriptor);
                if (!this.log.isInfoEnabled()) continue;
                this.log.info((Object)("Removed plugin module " + unrecognisedModuleDescriptor.getCompleteKey() + " as its factory was uninstalled"));
            }
        }
    }

    <T extends ModuleDescriptor<?>> List<T> getModuleDescriptorsByDescriptorClass(Class<T> descriptor) {
        ArrayList<T> result = new ArrayList<T>();
        for (ModuleDescriptor moduleDescriptor : this.plugin.getModuleDescriptors()) {
            if (!moduleDescriptor.getClass().isAssignableFrom(descriptor)) continue;
            result.add(descriptor.cast(moduleDescriptor));
        }
        return result;
    }
}

