/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.osgi.factory;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactBackedPlugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.impl.AbstractPlugin;
import com.atlassian.plugin.osgi.util.BundleClassLoaderAccessor;
import com.atlassian.plugin.util.resource.AlternativeDirectoryResourceLoader;
import com.atlassian.plugin.util.resource.AlternativeResourceLoader;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import org.apache.commons.lang.Validate;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class OsgiBundlePlugin
extends AbstractPlugin
implements PluginArtifactBackedPlugin {
    private final Bundle bundle;
    private final Date dateLoaded;
    private final ClassLoader bundleClassLoader;
    private final SynchronousBundleListener bundleStopListener;
    private final PluginArtifact pluginArtifact;

    public OsgiBundlePlugin(final Bundle bundle, String key, PluginArtifact pluginArtifact, PluginEventManager pluginEventManager) {
        this.pluginArtifact = pluginArtifact;
        this.bundleClassLoader = BundleClassLoaderAccessor.getClassLoader(bundle, (AlternativeResourceLoader)new AlternativeDirectoryResourceLoader());
        Validate.notNull((Object)bundle);
        this.bundle = bundle;
        this.bundleStopListener = new SynchronousBundleListener(){

            public void bundleChanged(BundleEvent bundleEvent) {
                if (bundleEvent.getBundle() == bundle && bundleEvent.getType() == 256) {
                    OsgiBundlePlugin.this.setPluginState(PluginState.DISABLED);
                }
            }
        };
        PluginInformation pluginInformation = new PluginInformation();
        pluginInformation.setDescription((String)bundle.getHeaders().get("Bundle-Description"));
        pluginInformation.setVersion((String)bundle.getHeaders().get("Bundle-Version"));
        pluginInformation.setVendorName((String)bundle.getHeaders().get("Bundle-Vendor"));
        this.dateLoaded = new Date();
        this.setPluginsVersion(2);
        this.setName((String)bundle.getHeaders().get("Bundle-Name"));
        this.setKey(key);
        this.setPluginInformation(pluginInformation);
        this.setSystemPlugin(false);
    }

    public Date getDateLoaded() {
        return this.dateLoaded;
    }

    public boolean isUninstallable() {
        return true;
    }

    public boolean isDeleteable() {
        return true;
    }

    public boolean isDynamicallyLoaded() {
        return true;
    }

    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        return BundleClassLoaderAccessor.loadClass(this.bundle, clazz);
    }

    public URL getResource(String name) {
        return this.bundleClassLoader.getResource(name);
    }

    public InputStream getResourceAsStream(String name) {
        return this.bundleClassLoader.getResourceAsStream(name);
    }

    protected void uninstallInternal() {
        try {
            if (this.bundle.getState() != 1) {
                this.bundle.uninstall();
            }
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    protected PluginState enableInternal() {
        try {
            this.bundle.start();
            this.bundle.getBundleContext().addBundleListener((BundleListener)this.bundleStopListener);
            return PluginState.ENABLED;
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    protected void disableInternal() {
        try {
            if (this.bundle.getState() == 32) {
                this.bundle.stop();
            }
        }
        catch (BundleException e) {
            throw new PluginException((Throwable)e);
        }
    }

    public ClassLoader getClassLoader() {
        return this.bundleClassLoader;
    }

    public PluginArtifact getPluginArtifact() {
        return this.pluginArtifact;
    }
}

