/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.atlassian;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.gemini.blueprint.context.support.OsgiBundleXmlApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.QualifierAnnotationAutowireCandidateResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.osgi.context.BundleContextAware;

public class NonValidatingOsgiBundleXmlApplicationContext
extends OsgiBundleXmlApplicationContext {
    public NonValidatingOsgiBundleXmlApplicationContext(String[] configLocations) {
        super(configLocations);
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader) {
        super.initBeanDefinitionReader(beanDefinitionReader);
        beanDefinitionReader.setValidationMode(0);
        beanDefinitionReader.setNamespaceAware(true);
    }

    protected void customizeBeanFactory(DefaultListableBeanFactory beanFactory) {
        if (Boolean.getBoolean("atlassian.disable.spring.cache.bean.metadata")) {
            beanFactory.setCacheBeanMetadata(false);
        }
        if (!Boolean.getBoolean("atlassian.enable.spring.parameter.name.discoverer")) {
            beanFactory.setParameterNameDiscoverer(new ParameterNameDiscoverer(){

                public String[] getParameterNames(Method method) {
                    return null;
                }

                public String[] getParameterNames(Constructor<?> ctor) {
                    return null;
                }
            });
        }
        super.customizeBeanFactory(beanFactory);
        beanFactory.addBeanPostProcessor((BeanPostProcessor)new ShimSpringDmBundleContextAwareBeanPostProcessor());
        beanFactory.setAutowireCandidateResolver((AutowireCandidateResolver)new QualifierAnnotationAutowireCandidateResolver());
    }

    private class ShimSpringDmBundleContextAwareBeanPostProcessor
    implements BeanPostProcessor {
        private ShimSpringDmBundleContextAwareBeanPostProcessor() {
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof BundleContextAware) {
                ((BundleContextAware)bean).setBundleContext(NonValidatingOsgiBundleXmlApplicationContext.this.getBundleContext());
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

