package com.atlassian.plugins.osgi.javaconfig.conditions;

import com.atlassian.annotations.PublicApi;

/**
 * An {@link org.springframework.context.annotation.Condition} that returns <code>true</code> if the system property
 * <code>{@value #ATLASSIAN_DEV_MODE_PROP}</code> is set to <code>"true"</code>.
 */
@SuppressWarnings("WeakerAccess")
@PublicApi
public final class DevModeOnly extends AbstractSystemPropertyCondition {

    /**
     * The name of the system property that indicates whether an Atlassian product is running in development mode.
     */
    public static final String ATLASSIAN_DEV_MODE_PROP = "atlassian.dev.mode";

    public DevModeOnly() {
        super(ATLASSIAN_DEV_MODE_PROP, "true");
    }
}
