/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.main;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.SplitStartupPluginSystemLifecycle;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.impl.DefaultPluginEventManager;
import com.atlassian.plugin.factories.AbstractPluginFactory;
import com.atlassian.plugin.factories.LegacyDynamicPluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import com.atlassian.plugin.loaders.ClassPathPluginLoader;
import com.atlassian.plugin.loaders.DirectoryPluginLoader;
import com.atlassian.plugin.main.HotDeployer;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.felix.FelixOsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiBundleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPluginFactory;
import com.atlassian.plugin.osgi.factory.RemotablePluginFactory;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class AtlassianPlugins {
    private OsgiContainerManager osgiContainerManager;
    private DefaultPluginEventManager pluginEventManager = new DefaultPluginEventManager();
    private DefaultPluginManager pluginManager;
    private HotDeployer hotDeployer;
    private EventPublisher eventPublisher = this.pluginEventManager.getEventPublisher();
    public static final String TEMP_DIRECTORY_SUFFIX = ".tmp";

    public AtlassianPlugins(PluginsConfiguration config) {
        AtomicReference<PluginAccessor> pluginManagerRef = new AtomicReference<PluginAccessor>();
        this.osgiContainerManager = new FelixOsgiContainerManager(config.getFrameworkBundleDirectory(), config.getOsgiPersistentCache(), config.getPackageScannerConfiguration(), (HostComponentProvider)new CriticalHostComponentProvider(config.getHostComponentProvider(), (PluginEventManager)this.pluginEventManager, pluginManagerRef), (PluginEventManager)this.pluginEventManager);
        Set applications = config.getApplication() != null ? Sets.newHashSet((Object[])new Application[]{config.getApplication()}) : ImmutableSet.of();
        OsgiPluginFactory osgiPluginDeployer = new OsgiPluginFactory(config.getPluginDescriptorFilename(), applications, config.getOsgiPersistentCache(), this.osgiContainerManager, (PluginEventManager)this.pluginEventManager);
        OsgiBundleFactory osgiBundleDeployer = new OsgiBundleFactory(this.osgiContainerManager);
        RemotablePluginFactory remotablePluginFactory = new RemotablePluginFactory(config.getPluginDescriptorFilename(), applications, this.osgiContainerManager, (PluginEventManager)this.pluginEventManager);
        LinkedList<AbstractPluginFactory> pluginDeployers = new LinkedList<AbstractPluginFactory>(Arrays.asList(osgiPluginDeployer, osgiBundleDeployer, remotablePluginFactory));
        if (config.isUseLegacyDynamicPluginDeployer()) {
            pluginDeployers.add((AbstractPluginFactory)new LegacyDynamicPluginFactory(config.getPluginDescriptorFilename()));
        }
        ArrayList<Object> pluginLoaders = new ArrayList<Object>();
        pluginLoaders.add(new ClassPathPluginLoader());
        if (config.getBundledPluginUrl() != null) {
            pluginLoaders.add(new BundledPluginLoader(config.getBundledPluginUrl(), config.getBundledPluginCacheDirectory(), pluginDeployers, (PluginEventManager)this.pluginEventManager));
        }
        pluginLoaders.add(new DirectoryPluginLoader(config.getPluginDirectory(), pluginDeployers, (PluginEventManager)this.pluginEventManager));
        this.pluginManager = new DefaultPluginManager(config.getPluginStateStore(), pluginLoaders, config.getModuleDescriptorFactory(), (PluginEventManager)this.pluginEventManager);
        pluginManagerRef.set((PluginAccessor)this.pluginManager);
        this.pluginManager.setPluginInstaller((PluginInstaller)new FilePluginInstaller(config.getPluginDirectory()));
        if (config.getHotDeployPollingPeriod() > 0L) {
            this.hotDeployer = new HotDeployer((PluginController)this.pluginManager, config.getHotDeployPollingPeriod());
        }
    }

    public void afterPropertiesSet() {
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() {
        this.pluginEventManager.unregister((Object)this);
    }

    @Deprecated
    public void start() throws PluginParseException {
        this.afterPropertiesSet();
        this.getPluginSystemLifecycle().init();
    }

    @Deprecated
    public void stop() {
        this.getPluginSystemLifecycle().shutdown();
        this.destroy();
    }

    public OsgiContainerManager getOsgiContainerManager() {
        return this.osgiContainerManager;
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public EventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public PluginController getPluginController() {
        return this.pluginManager;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginManager;
    }

    public SplitStartupPluginSystemLifecycle getPluginSystemLifecycle() {
        return this.pluginManager;
    }

    @PluginEventListener
    public void onPluginFrameworkStartedEvent(PluginFrameworkStartedEvent event) {
        if (this.hotDeployer != null && !this.hotDeployer.isRunning()) {
            this.hotDeployer.start();
        }
    }

    @PluginEventListener
    public void onPluginFrameworkShutdownEvent(PluginFrameworkShutdownEvent event) {
        if (this.hotDeployer != null && this.hotDeployer.isRunning()) {
            this.hotDeployer.stop();
        }
    }

    private static class CriticalHostComponentProvider
    implements HostComponentProvider {
        private final HostComponentProvider delegate;
        private final PluginEventManager pluginEventManager;
        private final AtomicReference<PluginAccessor> pluginManagerRef;

        public CriticalHostComponentProvider(HostComponentProvider delegate, PluginEventManager pluginEventManager, AtomicReference<PluginAccessor> pluginManagerRef) {
            this.delegate = delegate;
            this.pluginEventManager = pluginEventManager;
            this.pluginManagerRef = pluginManagerRef;
        }

        public void provide(ComponentRegistrar registrar) {
            registrar.register(new Class[]{PluginEventManager.class}).forInstance((Object)this.pluginEventManager);
            registrar.register(new Class[]{PluginAccessor.class}).forInstance((Object)this.pluginManagerRef.get());
            this.delegate.provide(registrar);
        }
    }
}

