/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.main;

import com.atlassian.plugin.DefaultModuleDescriptorFactory;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.hostcontainer.DefaultHostContainer;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.main.PackageScannerConfigurationBuilder;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.manager.store.MemoryPluginPersistentStateStore;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.impl.DefaultOsgiPersistentCache;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.util.Assertions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;

public class PluginsConfigurationBuilder {
    private PackageScannerConfiguration packageScannerConfiguration;
    private HostComponentProvider hostComponentProvider;
    private File osgiPersistentCache;
    private File pluginDirectory;
    private URL bundledPluginUrl;
    private File bundledPluginCacheDirectory;
    private String pluginDescriptorFilename;
    private ModuleDescriptorFactory moduleDescriptorFactory;
    private PluginPersistentStateStore pluginStateStore;
    private long hotDeployPollingPeriod;
    private boolean useLegacyDynamicPluginDeployer = false;
    private String applicationKey;

    public static PluginsConfigurationBuilder pluginsConfiguration() {
        return new PluginsConfigurationBuilder();
    }

    public PluginsConfigurationBuilder packageScannerConfiguration(PackageScannerConfiguration packageScannerConfiguration) {
        this.packageScannerConfiguration = (PackageScannerConfiguration)Assertions.notNull((String)"packageScannerConfiguration", (Object)packageScannerConfiguration);
        return this;
    }

    public PluginsConfigurationBuilder hostComponentProvider(HostComponentProvider hostComponentProvider) {
        this.hostComponentProvider = (HostComponentProvider)Assertions.notNull((String)"hostComponentProvider", (Object)hostComponentProvider);
        return this;
    }

    public PluginsConfigurationBuilder osgiPersistentCache(File osgiPersistentCache) {
        this.osgiPersistentCache = osgiPersistentCache;
        return this;
    }

    public PluginsConfigurationBuilder pluginDirectory(File pluginDirectory) {
        this.pluginDirectory = pluginDirectory;
        return this;
    }

    public PluginsConfigurationBuilder bundledPluginUrl(URL bundledPluginUrl) {
        this.bundledPluginUrl = bundledPluginUrl;
        return this;
    }

    public PluginsConfigurationBuilder bundledPluginCacheDirectory(File bundledPluginCacheDirectory) {
        this.bundledPluginCacheDirectory = bundledPluginCacheDirectory;
        return this;
    }

    public PluginsConfigurationBuilder pluginDescriptorFilename(String pluginDescriptorFilename) {
        this.pluginDescriptorFilename = pluginDescriptorFilename;
        return this;
    }

    public PluginsConfigurationBuilder moduleDescriptorFactory(ModuleDescriptorFactory moduleDescriptorFactory) {
        this.moduleDescriptorFactory = moduleDescriptorFactory;
        return this;
    }

    public PluginsConfigurationBuilder pluginStateStore(PluginPersistentStateStore pluginStateStore) {
        this.pluginStateStore = pluginStateStore;
        return this;
    }

    public PluginsConfigurationBuilder hotDeployPollingFrequency(long hotDeployPollingFrequency, TimeUnit timeUnit) {
        this.hotDeployPollingPeriod = timeUnit.toMillis(hotDeployPollingFrequency);
        return this;
    }

    public PluginsConfigurationBuilder useLegacyDynamicPluginDeployer(boolean useLegacyDynamicPluginDeployer) {
        this.useLegacyDynamicPluginDeployer = useLegacyDynamicPluginDeployer;
        return this;
    }

    public PluginsConfigurationBuilder applicationKey(String applicationKey) {
        this.applicationKey = applicationKey;
        return this;
    }

    public PluginsConfiguration build() {
        Assertions.notNull((String)"Plugin directory must be defined", (Object)this.pluginDirectory);
        Assertions.isTrue((String)"Plugin directory must exist", (boolean)this.pluginDirectory.exists());
        if (this.packageScannerConfiguration == null) {
            this.packageScannerConfiguration = new PackageScannerConfigurationBuilder().build();
        }
        if (this.pluginDescriptorFilename == null) {
            this.pluginDescriptorFilename = "atlassian-plugin.xml";
        }
        if (this.hostComponentProvider == null) {
            this.hostComponentProvider = new HostComponentProvider(){

                public void provide(ComponentRegistrar registrar) {
                }
            };
        }
        if (this.pluginStateStore == null) {
            this.pluginStateStore = new MemoryPluginPersistentStateStore();
        }
        if (this.moduleDescriptorFactory == null) {
            this.moduleDescriptorFactory = new DefaultModuleDescriptorFactory((HostContainer)new DefaultHostContainer());
        }
        if (this.osgiPersistentCache == null) {
            this.osgiPersistentCache = this.createTempDir("atlassian-plugins-osgi-cache");
        }
        if (this.bundledPluginUrl != null && this.bundledPluginCacheDirectory == null) {
            throw new IllegalArgumentException("Bundled plugin cache directory MUST be defined when bundled plugin URL is defined");
        }
        return new InternalPluginsConfiguration(this);
    }

    private File createTempDir(String prefix) {
        try {
            File directory = File.createTempFile(prefix, ".tmp");
            directory.delete();
            directory.mkdir();
            return directory;
        }
        catch (IOException e) {
            throw new IllegalStateException("Was not able to create temp file with prefix <" + prefix + ">", e);
        }
    }

    private static class InternalPluginsConfiguration
    implements PluginsConfiguration {
        private final PackageScannerConfiguration packageScannerConfiguration;
        private final HostComponentProvider hostComponentProvider;
        private final OsgiPersistentCache osgiPersistentCache;
        private final File pluginDirectory;
        private final URL bundledPluginUrl;
        private final File bundledPluginCacheDirectory;
        private final String pluginDescriptorFilename;
        private final ModuleDescriptorFactory moduleDescriptorFactory;
        private final PluginPersistentStateStore pluginStateStore;
        private final long hotDeployPollingPeriod;
        private final boolean useLegacyDynamicPluginDeployer;
        private final String applicationKey;

        InternalPluginsConfiguration(PluginsConfigurationBuilder builder) {
            this.packageScannerConfiguration = builder.packageScannerConfiguration;
            this.hostComponentProvider = builder.hostComponentProvider;
            this.osgiPersistentCache = new DefaultOsgiPersistentCache(builder.osgiPersistentCache, builder.packageScannerConfiguration.getCurrentHostVersion());
            this.pluginDirectory = builder.pluginDirectory;
            this.bundledPluginUrl = builder.bundledPluginUrl;
            this.bundledPluginCacheDirectory = builder.bundledPluginCacheDirectory;
            this.pluginDescriptorFilename = builder.pluginDescriptorFilename;
            this.moduleDescriptorFactory = builder.moduleDescriptorFactory;
            this.pluginStateStore = builder.pluginStateStore;
            this.hotDeployPollingPeriod = builder.hotDeployPollingPeriod;
            this.useLegacyDynamicPluginDeployer = builder.useLegacyDynamicPluginDeployer;
            this.applicationKey = builder.applicationKey;
        }

        public PackageScannerConfiguration getPackageScannerConfiguration() {
            return this.packageScannerConfiguration;
        }

        public HostComponentProvider getHostComponentProvider() {
            return this.hostComponentProvider;
        }

        public String getPluginDescriptorFilename() {
            return this.pluginDescriptorFilename;
        }

        public File getPluginDirectory() {
            return this.pluginDirectory;
        }

        public URL getBundledPluginUrl() {
            return this.bundledPluginUrl;
        }

        public File getBundledPluginCacheDirectory() {
            return this.bundledPluginCacheDirectory;
        }

        public ModuleDescriptorFactory getModuleDescriptorFactory() {
            return this.moduleDescriptorFactory;
        }

        public PluginPersistentStateStore getPluginStateStore() {
            return this.pluginStateStore;
        }

        public long getHotDeployPollingPeriod() {
            return this.hotDeployPollingPeriod;
        }

        public boolean isUseLegacyDynamicPluginDeployer() {
            return this.useLegacyDynamicPluginDeployer;
        }

        public String getApplicationKey() {
            return this.applicationKey;
        }

        public OsgiPersistentCache getOsgiPersistentCache() {
            return this.osgiPersistentCache;
        }
    }
}

