/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.main;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.DefaultPluginEventManager;
import com.atlassian.plugin.factories.LegacyDynamicPluginFactory;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.loaders.BundledPluginLoader;
import com.atlassian.plugin.loaders.ClassPathPluginLoader;
import com.atlassian.plugin.loaders.DirectoryPluginLoader;
import com.atlassian.plugin.main.HotDeployer;
import com.atlassian.plugin.main.PluginsConfiguration;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.plugin.osgi.container.felix.FelixOsgiContainerManager;
import com.atlassian.plugin.osgi.factory.OsgiBundleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPluginFactory;
import com.atlassian.plugin.osgi.hostcomponents.ComponentRegistrar;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import com.atlassian.plugin.repositories.FilePluginInstaller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlassianPlugins {
    private OsgiContainerManager osgiContainerManager;
    private PluginEventManager pluginEventManager = new DefaultPluginEventManager();
    private DefaultPluginManager pluginManager;
    private HotDeployer hotDeployer;
    private static final Logger log = LoggerFactory.getLogger(AtlassianPlugins.class);
    public static final String TEMP_DIRECTORY_SUFFIX = ".tmp";

    public AtlassianPlugins(PluginsConfiguration config) {
        AtomicReference<PluginAccessor> pluginManagerRef = new AtomicReference<PluginAccessor>();
        this.osgiContainerManager = new FelixOsgiContainerManager(config.getOsgiPersistentCache(), config.getPackageScannerConfiguration(), (HostComponentProvider)new CriticalHostComponentProvider(config.getHostComponentProvider(), this.pluginEventManager, pluginManagerRef), this.pluginEventManager);
        OsgiPluginFactory osgiPluginDeployer = new OsgiPluginFactory(config.getPluginDescriptorFilename(), config.getApplicationKey(), config.getOsgiPersistentCache(), this.osgiContainerManager, this.pluginEventManager);
        OsgiBundleFactory osgiBundleDeployer = new OsgiBundleFactory(this.osgiContainerManager, this.pluginEventManager);
        LinkedList<PluginFactory> pluginDeployers = new LinkedList<PluginFactory>(Arrays.asList(osgiPluginDeployer, osgiBundleDeployer));
        if (config.isUseLegacyDynamicPluginDeployer()) {
            pluginDeployers.add((PluginFactory)new LegacyDynamicPluginFactory(config.getPluginDescriptorFilename()));
        }
        ArrayList<Object> pluginLoaders = new ArrayList<Object>();
        pluginLoaders.add(new ClassPathPluginLoader());
        if (config.getBundledPluginUrl() != null) {
            pluginLoaders.add(new BundledPluginLoader(config.getBundledPluginUrl(), config.getBundledPluginCacheDirectory(), pluginDeployers, this.pluginEventManager));
        }
        pluginLoaders.add(new DirectoryPluginLoader(config.getPluginDirectory(), pluginDeployers, this.pluginEventManager));
        this.pluginManager = new DefaultPluginManager(config.getPluginStateStore(), pluginLoaders, config.getModuleDescriptorFactory(), this.pluginEventManager);
        pluginManagerRef.set((PluginAccessor)this.pluginManager);
        this.pluginManager.setPluginInstaller((PluginInstaller)new FilePluginInstaller(config.getPluginDirectory()));
        if (config.getHotDeployPollingPeriod() > 0L) {
            this.hotDeployer = new HotDeployer((PluginController)this.pluginManager, config.getHotDeployPollingPeriod());
        }
    }

    public void start() throws PluginParseException {
        this.pluginManager.init();
        if (this.hotDeployer != null && !this.hotDeployer.isRunning()) {
            this.hotDeployer.start();
        }
    }

    public void stop() {
        if (this.hotDeployer != null && this.hotDeployer.isRunning()) {
            this.hotDeployer.stop();
        }
        this.pluginManager.shutdown();
    }

    public OsgiContainerManager getOsgiContainerManager() {
        return this.osgiContainerManager;
    }

    public PluginEventManager getPluginEventManager() {
        return this.pluginEventManager;
    }

    public PluginController getPluginController() {
        return this.pluginManager;
    }

    public PluginAccessor getPluginAccessor() {
        return this.pluginManager;
    }

    private static class CriticalHostComponentProvider
    implements HostComponentProvider {
        private final HostComponentProvider delegate;
        private final PluginEventManager pluginEventManager;
        private final AtomicReference<PluginAccessor> pluginManagerRef;

        public CriticalHostComponentProvider(HostComponentProvider delegate, PluginEventManager pluginEventManager, AtomicReference<PluginAccessor> pluginManagerRef) {
            this.delegate = delegate;
            this.pluginEventManager = pluginEventManager;
            this.pluginManagerRef = pluginManagerRef;
        }

        public void provide(ComponentRegistrar registrar) {
            registrar.register(new Class[]{PluginEventManager.class}).forInstance((Object)this.pluginEventManager);
            registrar.register(new Class[]{PluginAccessor.class}).forInstance((Object)this.pluginManagerRef.get());
            this.delegate.provide(registrar);
        }
    }
}

