/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util;

import java.util.Deque;
import java.util.LinkedList;

public class ClassLoaderStack {
    private static final ThreadLocal<Deque<ClassLoader>> classLoaderStack = new ThreadLocal();

    public static void push(ClassLoader loader) {
        if (loader == null) {
            return;
        }
        Deque<ClassLoader> stack = classLoaderStack.get();
        if (stack == null) {
            stack = new LinkedList<ClassLoader>();
            classLoaderStack.set(stack);
        }
        stack.push(Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(loader);
    }

    public static ClassLoader pop() {
        Deque<ClassLoader> stack = classLoaderStack.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(stack.pop());
        if (stack.isEmpty()) {
            classLoaderStack.remove();
        }
        return currentClassLoader;
    }
}

