/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginController;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeModuleExtractor {
    private static final Logger log = LoggerFactory.getLogger(SafeModuleExtractor.class);
    private final PluginController pluginController;

    public SafeModuleExtractor(PluginController pluginController) {
        this.pluginController = pluginController;
    }

    public <M> Iterable<M> getModules(Iterable<? extends ModuleDescriptor<M>> moduleDescriptors) {
        return Iterables.filter((Iterable)Iterables.transform(moduleDescriptors, (Function)new Function<ModuleDescriptor<M>, M>(){

            public M apply(@Nullable ModuleDescriptor<M> descriptor) {
                if (descriptor == null || descriptor.isBroken()) {
                    return null;
                }
                try {
                    return descriptor.getModule();
                }
                catch (RuntimeException ex) {
                    String pluginKey = descriptor.getPlugin().getKey();
                    log.error("Exception when retrieving plugin module {}, disabling plugin {}", new Object[]{descriptor.getCompleteKey(), pluginKey, ex});
                    descriptor.setBroken();
                    SafeModuleExtractor.this.pluginController.disablePluginWithoutPersisting(pluginKey);
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull());
    }
}

