/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModulePermissionException;
import com.atlassian.plugin.Permissions;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.ModuleDescriptors;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.loaders.LoaderUtils;
import com.atlassian.plugin.module.LegacyModuleFactory;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.module.PrefixDelegatingModuleFactory;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.util.ClassUtils;
import com.atlassian.plugin.util.JavaVersionUtils;
import com.atlassian.plugin.util.validation.ValidationPattern;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import org.dom4j.Element;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModuleDescriptor<T>
implements ModuleDescriptor<T>,
StateAware {
    private static final Logger log = LoggerFactory.getLogger(AbstractModuleDescriptor.class);
    protected Plugin plugin;
    protected String key;
    protected String name;
    protected String moduleClassName;
    protected Class<T> moduleClass;
    private String description;
    private boolean enabledByDefault = true;
    private boolean systemModule = false;
    private Optional<String> scopeKey = Optional.empty();
    @Deprecated
    protected boolean singleton = true;
    private Map<String, String> params;
    protected Resources resources = Resources.EMPTY_RESOURCES;
    private Float minJavaVersion;
    private String i18nNameKey;
    private String descriptionKey;
    private String completeKey;
    private boolean enabled = false;
    protected final ModuleFactory moduleFactory;
    private boolean broken = false;

    public AbstractModuleDescriptor(ModuleFactory moduleFactory) {
        this.moduleFactory = (ModuleFactory)Preconditions.checkNotNull((Object)moduleFactory, (Object)"Module creator factory cannot be null");
    }

    public void init(@Nonnull Plugin plugin, @Nonnull Element element) throws PluginParseException {
        this.validate(element);
        this.plugin = (Plugin)Assertions.notNull((String)"plugin", (Object)plugin);
        this.key = element.attributeValue("key");
        this.name = element.attributeValue("name");
        this.i18nNameKey = element.attributeValue("i18n-name-key");
        this.completeKey = this.buildCompleteKey(plugin, this.key);
        this.description = element.elementTextTrim("description");
        this.moduleClassName = element.attributeValue("class");
        Element descriptionElement = element.element("description");
        this.descriptionKey = descriptionElement != null ? descriptionElement.attributeValue("key") : null;
        String scopedAttribute = element.attributeValue("scoped");
        this.scopeKey = scopedAttribute == null || Boolean.TRUE.toString().equalsIgnoreCase(scopedAttribute) ? this.plugin.getScopeKey() : Optional.empty();
        this.params = LoaderUtils.getParams((Element)element);
        if ("disabled".equalsIgnoreCase(element.attributeValue("state"))) {
            this.enabledByDefault = false;
        }
        if ("true".equalsIgnoreCase(element.attributeValue("system"))) {
            this.systemModule = true;
        }
        if (element.element("java-version") != null) {
            this.minJavaVersion = Float.valueOf(element.element("java-version").attributeValue("min"));
        }
        this.singleton = "false".equalsIgnoreCase(element.attributeValue("singleton")) ? false : ("true".equalsIgnoreCase(element.attributeValue("singleton")) ? true : this.isSingletonByDefault());
        this.resources = Resources.fromXml((Element)element);
    }

    protected final void checkPermissions() throws ModulePermissionException {
        if (this.plugin.hasAllPermissions() || this.isSystemModule()) {
            return;
        }
        Sets.SetView difference = Sets.difference(this.getAllRequiredPermissions(), (Set)this.plugin.getActivePermissions());
        if (!difference.isEmpty()) {
            throw new ModulePermissionException(this.getCompleteKey(), (Set<String>)difference.immutableCopy());
        }
    }

    private Set<String> getAllRequiredPermissions() {
        ImmutableSet.Builder permissions = ImmutableSet.builder();
        permissions.addAll((Iterable)Permissions.getRequiredPermissions(this.getClass()));
        permissions.addAll(this.getRequiredPermissions());
        return permissions.build();
    }

    protected Set<String> getRequiredPermissions() {
        return ImmutableSet.of();
    }

    private void validate(Element element) {
        Assertions.notNull((String)"element", (Object)element);
        ValidationPattern pattern = ValidationPattern.createPattern();
        this.provideValidationRules(pattern);
        pattern.evaluate((Node)element);
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        pattern.rule(ValidationPattern.test("@key").withError("The key is required"));
    }

    @Deprecated
    protected void loadClass(Plugin plugin, Element element) throws PluginParseException {
        this.loadClass(plugin, element.attributeValue("class"));
    }

    protected void loadClass(Plugin plugin, String clazz) throws PluginParseException {
        if (this.moduleClassName != null) {
            if (this.moduleFactory instanceof LegacyModuleFactory) {
                this.moduleClass = ((LegacyModuleFactory)this.moduleFactory).getModuleClass(this.moduleClassName, (ModuleDescriptor)this);
            } else if (this.moduleFactory instanceof PrefixDelegatingModuleFactory) {
                this.moduleClass = ((PrefixDelegatingModuleFactory)this.moduleFactory).guessModuleClass(this.moduleClassName, this);
            }
        } else {
            this.moduleClass = Void.class;
        }
        if (this.moduleClass == null) {
            try {
                Class<?> moduleTypeClass = null;
                try {
                    moduleTypeClass = ClassUtils.getTypeArguments(AbstractModuleDescriptor.class, this.getClass()).get(0);
                }
                catch (RuntimeException ex) {
                    log.debug("Unable to get generic type, usually due to Class.forName() problems", (Throwable)ex);
                    moduleTypeClass = this.getModuleReturnClass();
                }
                this.moduleClass = moduleTypeClass;
            }
            catch (ClassCastException ex) {
                throw new IllegalStateException("The module class must be defined in a concrete instance of ModuleDescriptor and not as another generic type.");
            }
            if (this.moduleClass == null) {
                throw new IllegalStateException("The module class cannot be determined, likely because it needs a concrete module type defined in the generic type it passes to AbstractModuleDescriptor");
            }
        }
    }

    Class<?> getModuleReturnClass() {
        try {
            return this.getClass().getMethod("getModule", new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("The getModule() method is missing (!) on " + this.getClass());
        }
    }

    private String buildCompleteKey(Plugin plugin, String moduleKey) {
        if (plugin == null) {
            return null;
        }
        StringBuffer completeKeyBuffer = new StringBuffer(32);
        completeKeyBuffer.append(plugin.getKey()).append(":").append(moduleKey);
        return completeKeyBuffer.toString();
    }

    public void destroy() {
        this.destroy(this.plugin);
    }

    @Deprecated
    public void destroy(Plugin plugin) {
        if (this.enabled) {
            this.disabled();
        }
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault && this.satisfiesMinJavaVersion();
    }

    public boolean isSystemModule() {
        return this.systemModule;
    }

    @Deprecated
    public boolean isSingleton() {
        return this.singleton;
    }

    @Deprecated
    protected boolean isSingletonByDefault() {
        return true;
    }

    protected final void assertModuleClassImplements(Class<T> requiredModuleClazz) throws PluginParseException {
        if (!this.enabled) {
            throw new PluginParseException("Plugin module " + this.getKey() + " not enabled");
        }
        if (!requiredModuleClazz.isAssignableFrom(this.getModuleClass())) {
            throw new PluginParseException("Given module class: " + this.getModuleClass().getName() + " does not implement " + requiredModuleClazz.getName());
        }
    }

    public String getCompleteKey() {
        return this.completeKey;
    }

    public String getPluginKey() {
        return this.getPlugin().getKey();
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getModuleClass() {
        return this.moduleClass;
    }

    public abstract T getModule();

    public Optional<String> getScopeKey() {
        return this.scopeKey;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getI18nNameKey() {
        return this.i18nNameKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public List<ResourceDescriptor> getResourceDescriptors() {
        return this.resources.getResourceDescriptors();
    }

    public List<ResourceDescriptor> getResourceDescriptors(String type) {
        return this.resources.getResourceDescriptors(type);
    }

    public ResourceLocation getResourceLocation(String type, String name) {
        return this.resources.getResourceLocation(type, name);
    }

    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.resources.getResourceDescriptor(type, name);
    }

    public Float getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public boolean satisfiesMinJavaVersion() {
        if (this.minJavaVersion != null) {
            return JavaVersionUtils.satisfiesMinVersion((float)this.minJavaVersion.floatValue());
        }
        return true;
    }

    public void setPlugin(Plugin plugin) {
        this.completeKey = this.buildCompleteKey(plugin, this.key);
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean equals(Object obj) {
        return new ModuleDescriptors.EqualsBuilder().descriptor(this).isEqualTo(obj);
    }

    public int hashCode() {
        return new ModuleDescriptors.HashCodeBuilder().descriptor(this).toHashCode();
    }

    public String toString() {
        return this.getCompleteKey() + " (" + this.getDescription() + ")";
    }

    public void enabled() {
        this.loadClass(this.plugin, this.moduleClassName);
        this.enabled = true;
        this.broken = false;
    }

    public void disabled() {
        this.enabled = false;
        this.moduleClass = null;
    }

    protected String getModuleClassName() {
        return this.moduleClassName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setBroken() {
        this.broken = true;
    }

    public boolean isBroken() {
        return this.broken;
    }
}

