/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.predicate;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;

public class ModuleOfClassPredicate<T>
implements ModuleDescriptorPredicate<T> {
    private final Class<T> moduleClass;

    public ModuleOfClassPredicate(Class<T> moduleClass) {
        if (moduleClass == null) {
            throw new IllegalArgumentException("Module class should not be null when constructing ModuleOfClassPredicate!");
        }
        this.moduleClass = moduleClass;
    }

    public boolean matches(ModuleDescriptor<? extends T> moduleDescriptor) {
        if (moduleDescriptor != null) {
            Class moduleClassInDescriptor = moduleDescriptor.getModuleClass();
            return moduleClassInDescriptor != null && this.moduleClass.isAssignableFrom(moduleClassInDescriptor);
        }
        return false;
    }
}

