/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.module;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.atlassian.plugin.module.ModuleClassNotFoundException;
import com.atlassian.plugin.module.PrefixModuleFactory;

public class ClassPrefixModuleFactory
implements PrefixModuleFactory {
    protected final HostContainer hostContainer;

    public ClassPrefixModuleFactory(HostContainer hostContainer) {
        this.hostContainer = hostContainer;
    }

    public <T> T createModule(String name, ModuleDescriptor<T> moduleDescriptor) throws PluginParseException {
        Class cls = this.getModuleClass(name, moduleDescriptor);
        if (moduleDescriptor.getPlugin() instanceof ContainerManagedPlugin) {
            ContainerManagedPlugin cmPlugin = (ContainerManagedPlugin)moduleDescriptor.getPlugin();
            return (T)cmPlugin.getContainerAccessor().createBean(cls);
        }
        if (cls != null) {
            return (T)this.hostContainer.create(cls);
        }
        return null;
    }

    Class getModuleClass(String name, ModuleDescriptor moduleDescriptor) throws ModuleClassNotFoundException {
        try {
            return moduleDescriptor.getPlugin().loadClass(name, null);
        }
        catch (ClassNotFoundException e) {
            throw new ModuleClassNotFoundException(name, moduleDescriptor.getPluginKey(), moduleDescriptor.getKey(), (Exception)e, this.createErrorMsg(name));
        }
    }

    private String createErrorMsg(String className) {
        StringBuilder builder = new StringBuilder();
        builder.append("Couldn't load the class '").append(className).append("'. ");
        builder.append("This could mean that you misspelled the name of the class (double check) or that ");
        builder.append("you're using a class in your plugin that you haven't provided bundle instructions for. ");
        builder.append("See https://developer.atlassian.com/x/mQAN for more details on how to fix this.");
        return builder.toString();
    }

    @Override
    public String getPrefix() {
        return "class";
    }
}

