/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.factories;

import com.atlassian.plugin.Application;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.factories.AbstractPluginFactory;
import com.atlassian.plugin.impl.XmlDynamicPlugin;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.XmlDescriptorParserFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlDynamicPluginFactory
extends AbstractPluginFactory {
    private static final Logger log = LoggerFactory.getLogger(XmlDynamicPluginFactory.class);

    public XmlDynamicPluginFactory(Application application) {
        this(Sets.newHashSet((Object[])new Application[]{application}));
    }

    public XmlDynamicPluginFactory(Set<Application> applications) {
        super(new XmlDescriptorParserFactory(), applications);
    }

    @Override
    protected InputStream getDescriptorInputStream(PluginArtifact pluginArtifact) {
        return pluginArtifact.getInputStream();
    }

    @Override
    protected Predicate<Integer> isValidPluginsVersion() {
        return Predicates.alwaysTrue();
    }

    @Override
    public String canCreate(PluginArtifact pluginArtifact) throws PluginParseException {
        try {
            return super.canCreate(pluginArtifact);
        }
        catch (PluginParseException e) {
            if (e.getCause() instanceof DocumentException) {
                log.debug("There was an error parsing the plugin descriptor for '{}'", (Object)pluginArtifact);
                log.debug("This is most probably because we parsed a jar, and the plugin is not an XML dynamic plugin. See the exception below for confirmation:", (Throwable)e);
                return null;
            }
            throw e;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Plugin create(PluginArtifact pluginArtifact, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        Plugin plugin;
        Preconditions.checkNotNull((Object)pluginArtifact, (Object)"The plugin artifact must not be null");
        Preconditions.checkNotNull((Object)moduleDescriptorFactory, (Object)"The module descriptor factory must not be null");
        FileInputStream pluginDescriptor = null;
        try {
            pluginDescriptor = new FileInputStream(pluginArtifact.toFile());
            DescriptorParser parser = this.descriptorParserFactory.getInstance(pluginDescriptor, this.applications);
            plugin = parser.configurePlugin(moduleDescriptorFactory, new XmlDynamicPlugin(pluginArtifact));
        }
        catch (RuntimeException e) {
            try {
                throw new PluginParseException((Throwable)e);
                catch (IOException e2) {
                    throw new PluginParseException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(pluginDescriptor);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)pluginDescriptor);
        return plugin;
    }

    public ModuleDescriptor<?> createModule(Plugin plugin, Element module, ModuleDescriptorFactory moduleDescriptorFactory) {
        if (plugin instanceof XmlDynamicPlugin) {
            throw new PluginException("cannot create modules for an XmlDynamicPlugin");
        }
        return null;
    }
}

