/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactBackedPlugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.jmx.AbstractJmxBridge;
import com.atlassian.plugin.jmx.JmxUtil;
import com.atlassian.plugin.jmx.PluginManagerMXBean;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

class DefaultPluginManagerJmxBridge
extends AbstractJmxBridge<PluginManagerMXBean>
implements PluginManagerMXBean {
    private static final AtomicInteger nextJmxInstance = new AtomicInteger();
    private final DefaultPluginManager defaultPluginManager;

    DefaultPluginManagerJmxBridge(DefaultPluginManager defaultPluginManager) {
        super(JmxUtil.objectName(nextJmxInstance, "PluginManager"), PluginManagerMXBean.class);
        this.defaultPluginManager = defaultPluginManager;
    }

    @Override
    protected PluginManagerMXBean getMXBean() {
        return this;
    }

    @Override
    public PluginManagerMXBean.PluginData[] getPlugins() {
        Collection<Plugin> plugins = this.defaultPluginManager.getPlugins();
        Iterable pluginDatas = Iterables.transform(plugins, (Function)new Function<Plugin, PluginManagerMXBean.PluginData>(){

            public PluginManagerMXBean.PluginData apply(final Plugin plugin) {
                return new PluginManagerMXBean.PluginData(){

                    @Override
                    public String getKey() {
                        return plugin.getKey();
                    }

                    @Override
                    public String getVersion() {
                        PluginInformation pluginInformation = plugin.getPluginInformation();
                        return null == pluginInformation ? null : pluginInformation.getVersion();
                    }

                    @Override
                    public String getLocation() {
                        if (!(plugin instanceof PluginArtifactBackedPlugin)) {
                            return null;
                        }
                        PluginArtifact pluginArtifact = ((PluginArtifactBackedPlugin)plugin).getPluginArtifact();
                        return null == pluginArtifact ? null : pluginArtifact.toFile().getAbsolutePath();
                    }

                    @Override
                    public Long getDateLoaded() {
                        Date dateLoaded = plugin.getDateLoaded();
                        return null == dateLoaded ? null : Long.valueOf(dateLoaded.getTime());
                    }

                    @Override
                    public Long getDateInstalled() {
                        Date dateInstalled = plugin.getDateInstalled();
                        return null == dateInstalled ? null : Long.valueOf(dateInstalled.getTime());
                    }

                    @Override
                    public boolean isEnabled() {
                        return DefaultPluginManagerJmxBridge.this.defaultPluginManager.isPluginEnabled(plugin.getKey());
                    }

                    @Override
                    public boolean isEnabledByDefault() {
                        return plugin.isEnabledByDefault();
                    }

                    @Override
                    public boolean isBundledPlugin() {
                        return plugin.isBundledPlugin();
                    }
                };
            }
        });
        return (PluginManagerMXBean.PluginData[])Iterables.toArray((Iterable)pluginDatas, PluginManagerMXBean.PluginData.class);
    }

    @Override
    public int scanForNewPlugins() {
        return this.defaultPluginManager.scanForNewPlugins();
    }
}

