/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.manager;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.Internal;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginRestartState;
import com.atlassian.plugin.PluginState;
import com.atlassian.plugin.RevertablePluginInstaller;
import com.atlassian.plugin.SplitStartupPluginSystemLifecycle;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.classloader.PluginsClassLoader;
import com.atlassian.plugin.descriptors.CannotDisable;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.BeforePluginDisabledEvent;
import com.atlassian.plugin.event.events.BeforePluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginContainerUnavailableEvent;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkDelayedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkResumingEvent;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartingEvent;
import com.atlassian.plugin.event.events.PluginFrameworkWarmRestartedEvent;
import com.atlassian.plugin.event.events.PluginFrameworkWarmRestartingEvent;
import com.atlassian.plugin.event.events.PluginModuleAvailableEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleUnavailableEvent;
import com.atlassian.plugin.event.events.PluginRefreshedEvent;
import com.atlassian.plugin.event.events.PluginUninstalledEvent;
import com.atlassian.plugin.event.events.PluginUpgradedEvent;
import com.atlassian.plugin.exception.NoOpPluginExceptionInterception;
import com.atlassian.plugin.exception.PluginExceptionInterception;
import com.atlassian.plugin.impl.UnloadablePlugin;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.loaders.DiscardablePluginLoader;
import com.atlassian.plugin.loaders.DynamicPluginLoader;
import com.atlassian.plugin.loaders.PermissionCheckingPluginLoader;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.manager.NoOpRevertablePluginInstaller;
import com.atlassian.plugin.manager.PluginEnabler;
import com.atlassian.plugin.manager.PluginPersistentState;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.manager.StateTracker;
import com.atlassian.plugin.manager.UnsupportedPluginInstaller;
import com.atlassian.plugin.metadata.ClasspathFilePluginMetadata;
import com.atlassian.plugin.metadata.DefaultRequiredPluginValidator;
import com.atlassian.plugin.parsers.DescriptorParserFactory;
import com.atlassian.plugin.predicate.EnabledModulePredicate;
import com.atlassian.plugin.predicate.EnabledPluginPredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfClassPredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorOfTypePredicate;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import com.atlassian.plugin.predicate.ModuleOfClassPredicate;
import com.atlassian.plugin.predicate.PluginPredicate;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.util.PluginUtils;
import com.atlassian.plugin.util.collect.Transforms;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.io.InputStream;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.commons.lang.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginManager
implements PluginController,
PluginAccessor,
SplitStartupPluginSystemLifecycle {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginManager.class);
    private final List<DiscardablePluginLoader> pluginLoaders;
    private final PluginPersistentStateStore store;
    private final ModuleDescriptorFactory moduleDescriptorFactory;
    private final PluginEventManager pluginEventManager;
    private final Map<String, Plugin> plugins;
    private final PluginsClassLoader classLoader;
    private final PluginEnabler pluginEnabler;
    private final StateTracker tracker;
    private final boolean verifyRequiredPlugins;
    private final PluginPredicate delayLoadOf;
    private RevertablePluginInstaller pluginInstaller;
    private final Map<Plugin, PluginLoader> installedPluginsToPluginLoader;
    private final Map<Plugin, DiscardablePluginLoader> candidatePluginsToPluginLoader;
    private final List<Plugin> delayedPlugins;
    private final Map<Plugin, DiscardablePluginLoader> delayedPluginRemovalsToLoader;

    @Internal
    public static String getPluginSortModeProperty() {
        return PluginSortMode.PROPERTY_NAME;
    }

    private static PluginExceptionInterception defaultPluginExceptionInterception() {
        return NoOpPluginExceptionInterception.NOOP_INTERCEPTION;
    }

    private static boolean defaultVerifyRequiredPlugins() {
        return false;
    }

    private static PluginPredicate defaultDelayLoadOf() {
        return new PluginPredicate(){

            @Override
            public boolean matches(Plugin plugin) {
                return false;
            }
        };
    }

    public DefaultPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager) {
        this(store, pluginLoaders, moduleDescriptorFactory, pluginEventManager, DefaultPluginManager.defaultPluginExceptionInterception(), DefaultPluginManager.defaultVerifyRequiredPlugins(), DefaultPluginManager.defaultDelayLoadOf());
    }

    public DefaultPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, PluginExceptionInterception pluginExceptionInterception) {
        this(store, pluginLoaders, moduleDescriptorFactory, pluginEventManager, pluginExceptionInterception, DefaultPluginManager.defaultVerifyRequiredPlugins(), DefaultPluginManager.defaultDelayLoadOf());
    }

    public DefaultPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, boolean verifyRequiredPlugins) {
        this(store, pluginLoaders, moduleDescriptorFactory, pluginEventManager, DefaultPluginManager.defaultPluginExceptionInterception(), verifyRequiredPlugins, DefaultPluginManager.defaultDelayLoadOf());
    }

    @ExperimentalApi
    public DefaultPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, PluginPredicate delayLoadOf) {
        this(store, pluginLoaders, moduleDescriptorFactory, pluginEventManager, DefaultPluginManager.defaultPluginExceptionInterception(), DefaultPluginManager.defaultVerifyRequiredPlugins(), delayLoadOf);
    }

    @ExperimentalApi
    public DefaultPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, PluginExceptionInterception pluginExceptionInterception, PluginPredicate delayLoadOf) {
        this(store, pluginLoaders, moduleDescriptorFactory, pluginEventManager, pluginExceptionInterception, DefaultPluginManager.defaultVerifyRequiredPlugins(), delayLoadOf);
    }

    public DefaultPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, PluginExceptionInterception pluginExceptionInterception, boolean verifyRequiredPlugins) {
        this(store, pluginLoaders, moduleDescriptorFactory, pluginEventManager, pluginExceptionInterception, verifyRequiredPlugins, DefaultPluginManager.defaultDelayLoadOf());
    }

    @ExperimentalApi
    public DefaultPluginManager(PluginPersistentStateStore store, List<PluginLoader> pluginLoaders, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, PluginExceptionInterception pluginExceptionInterception, boolean verifyRequiredPlugins, PluginPredicate delayLoadOf) {
        this.pluginLoaders = this.toPermissionCheckingPluginLoaders(Assertions.notNull("Plugin Loaders list must not be null.", pluginLoaders));
        this.store = Assertions.notNull("PluginPersistentStateStore must not be null.", store);
        this.moduleDescriptorFactory = Assertions.notNull("ModuleDescriptorFactory must not be null.", moduleDescriptorFactory);
        this.pluginEventManager = Assertions.notNull("PluginEventManager must not be null.", pluginEventManager);
        this.pluginEnabler = new PluginEnabler(this, this, Assertions.notNull("PluginExceptionInterception must not be null.", pluginExceptionInterception));
        this.verifyRequiredPlugins = verifyRequiredPlugins;
        this.delayLoadOf = delayLoadOf;
        this.plugins = CopyOnWriteMap.builder().stableViews().newHashMap();
        this.tracker = new StateTracker();
        this.pluginInstaller = new NoOpRevertablePluginInstaller(new UnsupportedPluginInstaller());
        this.installedPluginsToPluginLoader = new HashMap<Plugin, PluginLoader>();
        this.candidatePluginsToPluginLoader = new HashMap<Plugin, DiscardablePluginLoader>();
        this.delayedPlugins = new ArrayList<Plugin>();
        this.delayedPluginRemovalsToLoader = new HashMap<Plugin, DiscardablePluginLoader>();
        this.pluginEventManager.register(this);
        this.classLoader = new PluginsClassLoader(null, this, pluginEventManager);
    }

    private List<DiscardablePluginLoader> toPermissionCheckingPluginLoaders(List<PluginLoader> fromIterable) {
        return Lists.newArrayList((Iterable)Iterables.transform(fromIterable, (Function)new Function<PluginLoader, DiscardablePluginLoader>(){

            public PermissionCheckingPluginLoader apply(PluginLoader pl) {
                return new PermissionCheckingPluginLoader(pl);
            }
        }));
    }

    @Override
    public void init() throws PluginParseException, NotificationException {
        this.earlyStartup();
        this.lateStartup();
    }

    @Override
    @ExperimentalApi
    public void earlyStartup() throws PluginParseException, NotificationException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        log.info("Plugin system earlyStartup begun");
        this.tracker.setState(StateTracker.State.STARTING);
        this.pluginEventManager.broadcast(new PluginFrameworkStartingEvent(this, this));
        this.pluginInstaller.clearBackups();
        TreeMultimap candidatePluginKeyToVersionedPlugins = TreeMultimap.create();
        for (DiscardablePluginLoader loader : this.pluginLoaders) {
            if (loader == null) continue;
            Iterable<Plugin> possiblePluginsToLoad = loader.loadAllPlugins(this.moduleDescriptorFactory);
            if (log.isDebugEnabled()) {
                log.debug("Found {} plugins to possibly load: {}", (Object)Iterables.size(possiblePluginsToLoad), Transforms.toPluginKeys(possiblePluginsToLoad));
            }
            for (Plugin plugin : possiblePluginsToLoad) {
                if (this.getState().getPluginRestartState(plugin.getKey()) == PluginRestartState.REMOVE) {
                    if (log.isInfoEnabled()) {
                        log.info("Plugin " + plugin.getKey() + " was marked to be removed on restart.  Removing now.");
                    }
                    this.delayedPluginRemovalsToLoader.put(plugin, loader);
                    continue;
                }
                this.candidatePluginsToPluginLoader.put(plugin, loader);
                candidatePluginKeyToVersionedPlugins.put((Object)plugin.getKey(), (Object)plugin);
            }
        }
        ArrayList<Plugin> pluginsToInstall = new ArrayList<Plugin>();
        for (Collection plugins : candidatePluginKeyToVersionedPlugins.asMap().values()) {
            Plugin plugin = (Plugin)Ordering.natural().max((Iterable)plugins);
            if (plugins.size() > 1) {
                log.debug("Plugin {} contained multiple versions. installing version {}.", (Object)plugin.getKey(), (Object)plugin.getPluginInformation().getVersion());
            }
            pluginsToInstall.add(plugin);
        }
        ArrayList<Plugin> immediatePlugins = new ArrayList<Plugin>();
        for (Plugin plugin : pluginsToInstall) {
            if (this.delayLoadOf.matches(plugin)) {
                this.delayedPlugins.add(plugin);
                continue;
            }
            immediatePlugins.add(plugin);
        }
        this.addPlugins(null, immediatePlugins);
        for (Plugin plugin : immediatePlugins) {
            this.candidatePluginsToPluginLoader.remove(plugin);
        }
        HashMap<Plugin, DiscardablePluginLoader> delayedPluginsLoaders = new HashMap<Plugin, DiscardablePluginLoader>();
        for (Plugin plugin : this.delayedPlugins) {
            DiscardablePluginLoader loader = this.candidatePluginsToPluginLoader.remove(plugin);
            delayedPluginsLoaders.put(plugin, loader);
        }
        for (Map.Entry entry : this.candidatePluginsToPluginLoader.entrySet()) {
            Plugin plugin = (Plugin)entry.getKey();
            DiscardablePluginLoader loader = (DiscardablePluginLoader)entry.getValue();
            loader.discardPlugin(plugin);
        }
        this.candidatePluginsToPluginLoader.clear();
        this.candidatePluginsToPluginLoader.putAll(delayedPluginsLoaders);
        this.tracker.setState(StateTracker.State.DELAYED);
        stopWatch.stop();
        log.info("Plugin system earlyStartup finished in " + stopWatch);
        this.pluginEventManager.broadcast(new PluginFrameworkDelayedEvent(this, this));
    }

    @Override
    @ExperimentalApi
    public void lateStartup() throws PluginParseException, NotificationException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        log.info("Plugin system lateStartup begun");
        this.tracker.setState(StateTracker.State.RESUMING);
        this.pluginEventManager.broadcast(new PluginFrameworkResumingEvent(this, this));
        this.addPlugins(null, this.delayedPlugins);
        this.delayedPlugins.clear();
        this.candidatePluginsToPluginLoader.clear();
        this.getStore().save(this.getBuilder().clearPluginRestartState().toState());
        for (Map.Entry<Plugin, DiscardablePluginLoader> entry : this.delayedPluginRemovalsToLoader.entrySet()) {
            Plugin plugin = entry.getKey();
            DiscardablePluginLoader loader = entry.getValue();
            loader.removePlugin(plugin);
            this.removeStateFromStore(this.getStore(), plugin);
        }
        this.delayedPluginRemovalsToLoader.clear();
        stopWatch.stop();
        log.info("Plugin system lateStartup finished in " + stopWatch);
        this.tracker.setState(StateTracker.State.STARTED);
        if (this.verifyRequiredPlugins) {
            this.validateRequiredPlugins();
        }
        this.pluginEventManager.broadcast(new PluginFrameworkStartedEvent(this, this));
    }

    private void validateRequiredPlugins() throws PluginException {
        DefaultRequiredPluginValidator validator = new DefaultRequiredPluginValidator(this, new ClasspathFilePluginMetadata());
        Collection<String> errors = validator.validate();
        if (errors.size() > 0) {
            log.error("Unable to validate required plugins or modules - plugin system shutting down");
            log.error("Failures:");
            for (String error : errors) {
                log.error("\t{}", (Object)error);
            }
            this.shutdown();
            throw new PluginException("Unable to validate required plugins or modules");
        }
    }

    @Override
    public void shutdown() {
        this.tracker.setState(StateTracker.State.SHUTTING_DOWN);
        log.info("Shutting down the plugin system");
        try {
            this.pluginEventManager.broadcast(new PluginFrameworkShutdownEvent(this, this));
        }
        catch (NotificationException ex) {
            log.error("At least one error occured while broadcasting the PluginFrameworkShutdownEvent. We will continue to shutdown the Plugin Manager anyway.");
        }
        this.plugins.clear();
        this.pluginEventManager.unregister(this);
        this.tracker.setState(StateTracker.State.SHUTDOWN);
    }

    @Override
    public final void warmRestart() {
        this.tracker.setState(StateTracker.State.WARM_RESTARTING);
        log.info("Initiating a warm restart of the plugin system");
        this.pluginEventManager.broadcast(new PluginFrameworkWarmRestartingEvent(this, this));
        ArrayList<Plugin> restartedPlugins = new ArrayList<Plugin>();
        ArrayList<DiscardablePluginLoader> loaders = new ArrayList<DiscardablePluginLoader>(this.pluginLoaders);
        Collections.reverse(loaders);
        for (DiscardablePluginLoader loader : this.pluginLoaders) {
            for (Map.Entry<Plugin, PluginLoader> entry : this.installedPluginsToPluginLoader.entrySet()) {
                Plugin plugin;
                if (entry.getValue() != loader || !this.isPluginEnabled((plugin = entry.getKey()).getKey())) continue;
                this.disablePluginModules(plugin);
                restartedPlugins.add(plugin);
            }
        }
        Collections.reverse(restartedPlugins);
        for (Plugin plugin : restartedPlugins) {
            this.enableConfiguredPluginModules(plugin);
        }
        this.pluginEventManager.broadcast(new PluginFrameworkWarmRestartedEvent(this, this));
        this.tracker.setState(StateTracker.State.STARTED);
    }

    @PluginEventListener
    public void onPluginModuleAvailable(PluginModuleAvailableEvent event) {
        this.enableConfiguredPluginModule(event.getModule().getPlugin(), event.getModule(), new HashSet());
    }

    @PluginEventListener
    public void onPluginModuleUnavailable(PluginModuleUnavailableEvent event) {
        this.notifyModuleDisabled(event.getModule());
    }

    @PluginEventListener
    public void onPluginContainerUnavailable(PluginContainerUnavailableEvent event) {
        this.disablePluginWithoutPersisting(event.getPluginKey());
    }

    @PluginEventListener
    public void onPluginRefresh(PluginRefreshedEvent event) {
        Plugin plugin = event.getPlugin();
        this.disablePluginModules(plugin);
        if (this.enableConfiguredPluginModules(plugin)) {
            this.pluginEventManager.broadcast(new PluginEnabledEvent(plugin));
        }
    }

    public void setPluginInstaller(PluginInstaller pluginInstaller) {
        this.pluginInstaller = pluginInstaller instanceof RevertablePluginInstaller ? (RevertablePluginInstaller)pluginInstaller : new NoOpRevertablePluginInstaller(pluginInstaller);
    }

    protected final PluginPersistentStateStore getStore() {
        return this.store;
    }

    @Override
    public String installPlugin(PluginArtifact pluginArtifact) throws PluginParseException {
        Set<String> keys = this.installPlugins(pluginArtifact);
        if (keys != null && keys.size() == 1) {
            return keys.iterator().next();
        }
        throw new PluginParseException("Could not install plugin");
    }

    @Override
    public Set<String> installPlugins(PluginArtifact ... pluginArtifacts) throws PluginParseException {
        LinkedHashMap<String, PluginArtifact> validatedArtifacts = new LinkedHashMap<String, PluginArtifact>();
        try {
            for (PluginArtifact pluginArtifact : pluginArtifacts) {
                validatedArtifacts.put(this.validatePlugin(pluginArtifact), pluginArtifact);
            }
        }
        catch (PluginParseException ex) {
            throw new PluginParseException("All plugins could not be validated", ex);
        }
        for (Map.Entry entry : validatedArtifacts.entrySet()) {
            this.pluginInstaller.installPlugin((String)entry.getKey(), (PluginArtifact)entry.getValue());
        }
        this.scanForNewPlugins();
        return validatedArtifacts.keySet();
    }

    String validatePlugin(PluginArtifact pluginArtifact) throws PluginParseException {
        boolean foundADynamicPluginLoader = false;
        for (DiscardablePluginLoader loader : this.pluginLoaders) {
            if (!loader.isDynamicPluginLoader()) continue;
            foundADynamicPluginLoader = true;
            String key = ((DynamicPluginLoader)((Object)loader)).canLoad(pluginArtifact);
            if (key == null) continue;
            return key;
        }
        if (!foundADynamicPluginLoader) {
            throw new IllegalStateException("Should be at least one DynamicPluginLoader in the plugin loader list");
        }
        throw new PluginParseException("Jar " + pluginArtifact.getName() + " is not a valid plugin!");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int scanForNewPlugins() throws PluginParseException {
        StateTracker.State state = this.tracker.get();
        Preconditions.checkState((StateTracker.State.RESUMING == state || StateTracker.State.STARTED == state ? 1 : 0) != 0, (String)"Cannot scanForNewPlugins in state %s", (Object[])new Object[]{state});
        int numberFound = 0;
        Iterator<DiscardablePluginLoader> i$ = this.pluginLoaders.iterator();
        while (i$.hasNext()) {
            DiscardablePluginLoader loader = i$.next();
            if (loader == null || !loader.supportsAddition()) continue;
            ArrayList<Plugin> pluginsToAdd = new ArrayList<Plugin>();
            for (Plugin plugin : loader.loadFoundPlugins(this.moduleDescriptorFactory)) {
                block9: {
                    Plugin oldPlugin = this.plugins.get(plugin.getKey());
                    if (plugin instanceof UnloadablePlugin) continue;
                    if (PluginUtils.doesPluginRequireRestart(plugin)) {
                        if (oldPlugin == null) {
                            this.markPluginInstallThatRequiresRestart(plugin);
                            UnloadablePlugin unloadablePlugin = UnloadablePluginFactory.createUnloadablePlugin(plugin);
                            unloadablePlugin.setErrorText("Plugin requires a restart of the application due to the following modules: " + PluginUtils.getPluginModulesThatRequireRestart(plugin));
                            plugin = unloadablePlugin;
                            break block9;
                        } else {
                            if (PluginRestartState.INSTALL.equals((Object)this.getPluginRestartState(plugin.getKey()))) continue;
                            this.markPluginUpgradeThatRequiresRestart(plugin);
                            continue;
                        }
                    }
                    if (oldPlugin != null && PluginUtils.doesPluginRequireRestart(oldPlugin)) {
                        if (PluginRestartState.INSTALL.equals((Object)this.getPluginRestartState(oldPlugin.getKey()))) {
                            this.revertRestartRequiredChange(oldPlugin.getKey());
                        } else {
                            this.markPluginUpgradeThatRequiresRestart(plugin);
                            continue;
                        }
                    }
                }
                pluginsToAdd.add(plugin);
            }
            this.addPlugins(loader, pluginsToAdd);
            numberFound = pluginsToAdd.size();
        }
        return numberFound;
    }

    private void markPluginInstallThatRequiresRestart(Plugin plugin) {
        if (log.isInfoEnabled()) {
            log.info("Installed plugin '" + plugin.getKey() + "' requires a restart due to the following modules: " + PluginUtils.getPluginModulesThatRequireRestart(plugin));
        }
        this.updateRequiresRestartState(plugin.getKey(), PluginRestartState.INSTALL);
    }

    private void markPluginUpgradeThatRequiresRestart(Plugin plugin) {
        if (log.isInfoEnabled()) {
            log.info("Upgraded plugin '" + plugin.getKey() + "' requires a restart due to the following modules: " + PluginUtils.getPluginModulesThatRequireRestart(plugin));
        }
        this.updateRequiresRestartState(plugin.getKey(), PluginRestartState.UPGRADE);
    }

    private void markPluginUninstallThatRequiresRestart(Plugin plugin) {
        if (log.isInfoEnabled()) {
            log.info("Uninstalled plugin '" + plugin.getKey() + "' requires a restart due to the following modules: " + PluginUtils.getPluginModulesThatRequireRestart(plugin));
        }
        this.updateRequiresRestartState(plugin.getKey(), PluginRestartState.REMOVE);
    }

    private void updateRequiresRestartState(String pluginKey, PluginRestartState pluginRestartState) {
        this.getStore().save(this.getBuilder().setPluginRestartState(pluginKey, pluginRestartState).toState());
        this.onUpdateRequiresRestartState(pluginKey, pluginRestartState);
    }

    protected void onUpdateRequiresRestartState(String pluginKey, PluginRestartState pluginRestartState) {
    }

    @Override
    public void uninstall(Plugin plugin) throws PluginException {
        if (PluginUtils.doesPluginRequireRestart(plugin)) {
            this.ensurePluginAndLoaderSupportsUninstall(plugin);
            this.markPluginUninstallThatRequiresRestart(plugin);
        } else {
            this.disableDependentPlugins(plugin.getKey());
            this.uninstallNoEvent(plugin);
            this.broadcastIgnoreError(new PluginUninstalledEvent(plugin));
        }
    }

    protected void uninstallNoEvent(Plugin plugin) {
        this.unloadPlugin(plugin);
        this.removeStateFromStore(this.getStore(), plugin);
    }

    @Override
    public void revertRestartRequiredChange(String pluginKey) throws PluginException {
        Assertions.notNull("pluginKey", pluginKey);
        PluginRestartState restartState = this.getState().getPluginRestartState(pluginKey);
        if (restartState == PluginRestartState.UPGRADE) {
            this.pluginInstaller.revertInstalledPlugin(pluginKey);
        } else if (restartState == PluginRestartState.INSTALL) {
            this.pluginInstaller.revertInstalledPlugin(pluginKey);
            this.plugins.remove(pluginKey);
        }
        this.updateRequiresRestartState(pluginKey, PluginRestartState.NONE);
    }

    protected void removeStateFromStore(PluginPersistentStateStore stateStore, Plugin plugin) {
        PluginPersistentState.Builder builder = PluginPersistentState.Builder.create(stateStore.load()).removeState(plugin.getKey());
        for (ModuleDescriptor<?> moduleDescriptor : plugin.getModuleDescriptors()) {
            builder.removeState(moduleDescriptor.getCompleteKey());
        }
        stateStore.save(builder.toState());
    }

    protected void unloadPlugin(Plugin plugin) throws PluginException {
        PluginLoader loader = this.ensurePluginAndLoaderSupportsUninstall(plugin);
        if (this.isPluginEnabled(plugin.getKey())) {
            this.notifyPluginDisabled(plugin);
        }
        this.notifyUninstallPlugin(plugin);
        if (loader != null) {
            this.removePluginFromLoader(plugin);
        }
        this.plugins.remove(plugin.getKey());
    }

    private PluginLoader ensurePluginAndLoaderSupportsUninstall(Plugin plugin) {
        if (!plugin.isUninstallable()) {
            throw new PluginException("Plugin is not uninstallable: " + plugin.getKey());
        }
        PluginLoader loader = this.installedPluginsToPluginLoader.get(plugin);
        if (loader != null && !loader.supportsRemoval()) {
            throw new PluginException("Not uninstalling plugin - loader doesn't allow removal. Plugin: " + plugin.getKey());
        }
        return loader;
    }

    private void removePluginFromLoader(Plugin plugin) throws PluginException {
        if (plugin.isDeleteable()) {
            PluginLoader pluginLoader = this.installedPluginsToPluginLoader.get(plugin);
            pluginLoader.removePlugin(plugin);
        }
        this.installedPluginsToPluginLoader.remove(plugin);
    }

    protected void notifyUninstallPlugin(Plugin plugin) {
        this.classLoader.notifyUninstallPlugin(plugin);
        for (ModuleDescriptor<?> descriptor : plugin.getModuleDescriptors()) {
            descriptor.destroy();
        }
    }

    protected PluginPersistentState getState() {
        return this.getStore().load();
    }

    @Deprecated
    protected void addPlugin(PluginLoader loader, Plugin plugin) throws PluginParseException {
        this.addPlugins(loader, Collections.singletonList(plugin));
    }

    protected void addPlugins(@Nullable PluginLoader loader, Collection<Plugin> pluginsToInstall) throws PluginParseException {
        ArrayList<Plugin> pluginsInEnableOrder;
        ArrayList<Plugin> pluginsToEnable = new ArrayList<Plugin>();
        for (Plugin plugin : new TreeSet<Plugin>(pluginsToInstall)) {
            boolean pluginUpgraded = false;
            String pluginKey = plugin.getKey();
            Plugin existingPlugin = this.plugins.get(pluginKey);
            if (existingPlugin != null) {
                if (plugin.compareTo(existingPlugin) >= 0) {
                    try {
                        pluginsToEnable.addAll(this.disableDependentPlugins(pluginKey));
                        this.updatePlugin(existingPlugin, plugin);
                        pluginsToEnable.remove(existingPlugin);
                        pluginUpgraded = true;
                    }
                    catch (PluginException e) {
                        throw new PluginParseException("Duplicate plugin found (installed version is the same or older) and could not be unloaded: '" + pluginKey + "'", e);
                    }
                } else {
                    log.debug("Duplicate plugin found (installed version is newer): '{}'", (Object)pluginKey);
                    if (null == loader) {
                        this.candidatePluginsToPluginLoader.get(plugin).discardPlugin(plugin);
                        continue;
                    }
                    if (loader instanceof DiscardablePluginLoader) {
                        ((DiscardablePluginLoader)loader).discardPlugin(plugin);
                        continue;
                    }
                    log.debug("Ignoring discardPlugin({}, version {}) as delegate is not a DiscardablePluginLoader", (Object)pluginKey, (Object)plugin.getPluginInformation().getVersion());
                    continue;
                }
            }
            plugin.install();
            boolean isPluginEnabled = this.getState().isEnabled(plugin);
            if (isPluginEnabled) {
                log.debug("Plugin '{}' is to be enabled.", (Object)pluginKey);
                pluginsToEnable.add(plugin);
            } else if (plugin.isSystemPlugin()) {
                log.warn("System Plugin '{}' is disabled.", (Object)pluginKey);
            } else {
                log.debug("Plugin '{}' is disabled.", (Object)pluginKey);
            }
            if (pluginUpgraded) {
                this.pluginEventManager.broadcast(new PluginUpgradedEvent(plugin));
            }
            this.plugins.put(pluginKey, plugin);
            if (loader == null) {
                this.installedPluginsToPluginLoader.put(plugin, this.candidatePluginsToPluginLoader.get(plugin));
                continue;
            }
            this.installedPluginsToPluginLoader.put(plugin, loader);
        }
        PluginSortMode pluginSortMode = PluginSortMode.current();
        List<Plugin> list = pluginsInEnableOrder = PluginSortMode.SORTED.equals((Object)pluginSortMode) ? DefaultPluginManager.sortPluginsForEnable(pluginsToEnable, this.plugins) : pluginsToEnable;
        if (PluginSortMode.SHUFFLE.equals((Object)pluginSortMode)) {
            Collections.shuffle(pluginsInEnableOrder);
        }
        if (log.isDebugEnabled()) {
            log.debug("Found {} plugins to enable: {}", (Object)pluginsInEnableOrder.size(), Transforms.toPluginKeys(pluginsInEnableOrder));
        }
        this.pluginEnabler.enable(pluginsInEnableOrder);
        for (Plugin plugin : pluginsInEnableOrder) {
            if (plugin.getPluginState() != PluginState.ENABLED || !this.enableConfiguredPluginModules(plugin)) continue;
            this.pluginEventManager.broadcast(new PluginEnabledEvent(plugin));
        }
    }

    private Collection<Plugin> disableDependentPlugins(String pluginKey) {
        Collection<Plugin> dependentPlugins = this.getDependentPlugins(pluginKey, this.getEnabledPlugins());
        if (log.isInfoEnabled()) {
            log.info("Found dependent enabled plugins for uninstalled plugin '{}': {}.  Disabling...", (Object)pluginKey, Transforms.toPluginKeys(dependentPlugins));
        }
        for (Plugin depPlugin : dependentPlugins) {
            this.disablePluginWithoutPersisting(depPlugin.getKey());
        }
        return dependentPlugins;
    }

    @VisibleForTesting
    Collection<Plugin> getDependentPlugins(String rootPluginKey, Iterable<Plugin> pluginList) {
        ArrayListMultimap dependencies = ArrayListMultimap.create();
        for (Plugin p : pluginList) {
            for (String key : p.getRequiredPlugins()) {
                dependencies.put((Object)key, (Object)p);
            }
        }
        AbstractCollection dependentPlugins = PluginSortMode.LEGACY.equals((Object)PluginSortMode.current()) ? Sets.newHashSet() : new ArrayList();
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(rootPluginKey);
        HashSet visited = Sets.newHashSet((Object[])new String[]{rootPluginKey});
        while (!queue.isEmpty()) {
            String pluginKey = (String)queue.removeFirst();
            for (Plugin dependentPlugin : dependencies.get((Object)pluginKey)) {
                String dependentPluginKey = dependentPlugin.getKey();
                if (!visited.add(dependentPluginKey)) continue;
                dependentPlugins.add(dependentPlugin);
                queue.addLast(dependentPluginKey);
            }
        }
        return dependentPlugins;
    }

    @VisibleForTesting
    public static List<Plugin> sortPluginsForEnable(List<Plugin> pluginsToEnable, Map<String, Plugin> pluginKeyToPlugin) {
        ArrayList<Plugin> sortedList = new ArrayList<Plugin>();
        HashSet<Plugin> visited = new HashSet<Plugin>();
        for (Plugin plugin : pluginsToEnable) {
            DefaultPluginManager.sortPluginForEnable(plugin, sortedList, visited, pluginsToEnable, pluginKeyToPlugin);
        }
        return sortedList;
    }

    private static void sortPluginForEnable(Plugin currentPlugin, List<Plugin> sortedList, Set<Plugin> visited, Collection<Plugin> allowedPlugins, Map<String, Plugin> pluginKeyToPlugin) {
        if (visited.add(currentPlugin)) {
            for (String requiredKey : currentPlugin.getRequiredPlugins()) {
                Plugin requiredPlugin = pluginKeyToPlugin.get(requiredKey);
                if (null == requiredPlugin) continue;
                DefaultPluginManager.sortPluginForEnable(requiredPlugin, sortedList, visited, allowedPlugins, pluginKeyToPlugin);
            }
            if (allowedPlugins.contains(currentPlugin)) {
                sortedList.add(currentPlugin);
            }
        }
    }

    protected void updatePlugin(Plugin oldPlugin, Plugin newPlugin) throws PluginException {
        if (!oldPlugin.getKey().equals(newPlugin.getKey())) {
            throw new IllegalArgumentException("New plugin '" + newPlugin.getKey() + "' must have the same key as the old plugin '" + oldPlugin.getKey() + "'");
        }
        if (log.isInfoEnabled()) {
            PluginInformation oldInformation = oldPlugin.getPluginInformation();
            String oldVersion = oldInformation == null ? "?" : oldInformation.getVersion();
            PluginInformation newInformation = newPlugin.getPluginInformation();
            String newVersion = newInformation == null ? "?" : newInformation.getVersion();
            log.info("Updating plugin '{}' from version '{}' to version '{}'", new Object[]{oldPlugin.getKey(), oldVersion, newVersion});
        }
        HashMap<String, Boolean> oldPluginState = new HashMap<String, Boolean>(this.getState().getPluginStateMap(oldPlugin));
        if (log.isDebugEnabled()) {
            log.debug("Uninstalling old plugin: " + oldPlugin);
        }
        this.uninstallNoEvent(oldPlugin);
        if (log.isDebugEnabled()) {
            log.debug("Plugin uninstalled '" + oldPlugin + "', preserving old state");
        }
        final HashSet<String> newModuleKeys = new HashSet<String>();
        newModuleKeys.add(newPlugin.getKey());
        for (ModuleDescriptor<?> moduleDescriptor : newPlugin.getModuleDescriptors()) {
            newModuleKeys.add(moduleDescriptor.getCompleteKey());
        }
        Predicate<String> filter = new Predicate<String>(){

            public boolean apply(String o) {
                return newModuleKeys.contains(o);
            }
        };
        this.getStore().save(this.getBuilder().addState(Maps.filterKeys(oldPluginState, (Predicate)filter)).toState());
    }

    @Override
    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    @Override
    public Collection<Plugin> getPlugins(final PluginPredicate pluginPredicate) {
        return ImmutableList.copyOf((Iterable)Iterables.filter(this.getPlugins(), (Predicate)new Predicate<Plugin>(){

            public boolean apply(Plugin plugin) {
                return pluginPredicate.matches(plugin);
            }
        }));
    }

    @Override
    public Collection<Plugin> getEnabledPlugins() {
        return this.getPlugins(new EnabledPluginPredicate(this));
    }

    @Override
    public <M> Collection<M> getModules(ModuleDescriptorPredicate<M> moduleDescriptorPredicate) {
        return ImmutableList.copyOf(this.getModules(this.getModuleDescriptors(this.getPlugins(), moduleDescriptorPredicate)));
    }

    @Override
    public <M> Collection<ModuleDescriptor<M>> getModuleDescriptors(ModuleDescriptorPredicate<M> moduleDescriptorPredicate) {
        return ImmutableList.copyOf(this.getModuleDescriptors(this.getPlugins(), moduleDescriptorPredicate));
    }

    private <M> Iterable<ModuleDescriptor<M>> getModuleDescriptors(Collection<Plugin> plugins, final ModuleDescriptorPredicate<M> predicate) {
        final Function coercer = new Function<ModuleDescriptor<?>, ModuleDescriptor<M>>(){

            public ModuleDescriptor<M> apply(ModuleDescriptor<?> input) {
                ModuleDescriptor<?> result = input;
                return result;
            }
        };
        final Predicate adapter = new Predicate<ModuleDescriptor<M>>(){

            public boolean apply(ModuleDescriptor<M> input) {
                return predicate.matches(input);
            }
        };
        Function descriptorExtractor = new Function<Plugin, Iterable<ModuleDescriptor<M>>>(){

            public Iterable<ModuleDescriptor<M>> apply(Plugin plugin) {
                return Iterables.filter((Iterable)Iterables.transform(plugin.getModuleDescriptors(), (Function)coercer), (Predicate)adapter);
            }
        };
        return Iterables.concat((Iterable)Iterables.transform(plugins, (Function)descriptorExtractor));
    }

    private <M> Iterable<M> getModules(Iterable<ModuleDescriptor<M>> moduleDescriptors) {
        return Iterables.filter((Iterable)Iterables.transform(moduleDescriptors, (Function)new Function<ModuleDescriptor<M>, M>(){
            private final Set<String> disabled = new HashSet<String>();

            public M apply(ModuleDescriptor<M> input) {
                try {
                    return input.getModule();
                }
                catch (RuntimeException ex) {
                    String key = input.getPlugin().getKey();
                    log.error("Exception when retrieving plugin module {}", (Object)input.getKey(), (Object)ex);
                    if (this.disabled.contains(key)) {
                        return null;
                    }
                    log.error("Disabling plugin {}", (Object)key);
                    this.disabled.add(key);
                    DefaultPluginManager.this.disablePlugin(key);
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull());
    }

    @Override
    public Plugin getPlugin(String key) {
        return this.plugins.get(Assertions.notNull("The plugin key must be specified", key));
    }

    @Override
    public Plugin getEnabledPlugin(String pluginKey) {
        if (!this.isPluginEnabled(pluginKey)) {
            return null;
        }
        return this.getPlugin(pluginKey);
    }

    @Override
    public ModuleDescriptor<?> getPluginModule(String completeKey) {
        return this.getPluginModule(new ModuleCompleteKey(completeKey));
    }

    private ModuleDescriptor<?> getPluginModule(ModuleCompleteKey key) {
        Plugin plugin = this.getPlugin(key.getPluginKey());
        if (plugin == null) {
            return null;
        }
        return plugin.getModuleDescriptor(key.getModuleKey());
    }

    @Override
    public ModuleDescriptor<?> getEnabledPluginModule(String completeKey) {
        ModuleCompleteKey key = new ModuleCompleteKey(completeKey);
        if (!this.isPluginModuleEnabled(key)) {
            return null;
        }
        return this.getEnabledPlugin(key.getPluginKey()).getModuleDescriptor(key.getModuleKey());
    }

    @Override
    public <M> List<M> getEnabledModulesByClass(Class<M> moduleClass) {
        return ImmutableList.copyOf(this.getModules(this.getEnabledModuleDescriptorsByModuleClass(moduleClass)));
    }

    @Override
    @Deprecated
    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>>[] descriptorClasses, Class<M> moduleClass) {
        Iterable<ModuleDescriptor<M>> moduleDescriptors = DefaultPluginManager.filterDescriptors(this.getEnabledModuleDescriptorsByModuleClass(moduleClass), new ModuleDescriptorOfClassPredicate<M>(descriptorClasses));
        return ImmutableList.copyOf(this.getModules(moduleDescriptors));
    }

    @Override
    @Deprecated
    public <M> List<M> getEnabledModulesByClassAndDescriptor(Class<ModuleDescriptor<M>> descriptorClass, Class<M> moduleClass) {
        Collection<ModuleDescriptor<M>> moduleDescriptors = this.getEnabledModuleDescriptorsByModuleClass(moduleClass);
        return ImmutableList.copyOf(this.getModules(DefaultPluginManager.filterDescriptors(moduleDescriptors, new ModuleDescriptorOfClassPredicate<M>(descriptorClass))));
    }

    private <M> Collection<ModuleDescriptor<M>> getEnabledModuleDescriptorsByModuleClass(Class<M> moduleClass) {
        final ModuleOfClassPredicate<M> ofType = new ModuleOfClassPredicate<M>(moduleClass);
        final EnabledModulePredicate enabled = new EnabledModulePredicate(this);
        return ImmutableList.copyOf(this.getModuleDescriptors(this.getEnabledPlugins(), new ModuleDescriptorPredicate<M>(){

            @Override
            public boolean matches(ModuleDescriptor<? extends M> moduleDescriptor) {
                return ofType.matches(moduleDescriptor) && enabled.matches(moduleDescriptor);
            }
        }));
    }

    @Override
    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClazz) {
        LinkedList<D> result = new LinkedList<D>();
        for (Plugin plugin : this.plugins.values()) {
            if (!this.isPluginEnabled(plugin.getKey())) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Plugin [" + plugin.getKey() + "] is disabled.");
                continue;
            }
            for (ModuleDescriptor<?> module : plugin.getModuleDescriptors()) {
                if (!descriptorClazz.isInstance(module)) continue;
                if (this.isPluginModuleEnabled(module.getCompleteKey())) {
                    result.add(descriptorClazz.cast(module));
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Module [" + module.getCompleteKey() + "] is disabled.");
            }
        }
        return result;
    }

    @Override
    public <D extends ModuleDescriptor<?>> List<D> getEnabledModuleDescriptorsByClass(Class<D> descriptorClazz, boolean verbose) {
        return this.getEnabledModuleDescriptorsByClass(descriptorClazz);
    }

    @Override
    @Deprecated
    public <M> List<ModuleDescriptor<M>> getEnabledModuleDescriptorsByType(String type) throws PluginParseException, IllegalArgumentException {
        final ModuleDescriptorOfTypePredicate ofType = new ModuleDescriptorOfTypePredicate(this.moduleDescriptorFactory, type);
        final EnabledModulePredicate enabled = new EnabledModulePredicate(this);
        return ImmutableList.copyOf(this.getModuleDescriptors(this.getEnabledPlugins(), new ModuleDescriptorPredicate<M>(){

            @Override
            public boolean matches(ModuleDescriptor<? extends M> moduleDescriptor) {
                return ofType.matches(moduleDescriptor) && enabled.matches(moduleDescriptor);
            }
        }));
    }

    private static <M> Iterable<ModuleDescriptor<M>> filterDescriptors(Iterable<ModuleDescriptor<M>> descriptors, final ModuleDescriptorPredicate<M> predicate) {
        return Iterables.filter(descriptors, (Predicate)new Predicate<ModuleDescriptor<M>>(){

            public boolean apply(ModuleDescriptor<M> input) {
                return predicate.matches(input);
            }
        });
    }

    @Override
    public void enablePlugins(String ... keys) {
        ArrayList<Plugin> pluginsToEnable = new ArrayList<Plugin>(keys.length);
        for (String key : keys) {
            if (key == null) {
                throw new IllegalArgumentException("Keys passed to enablePlugins must be non-null");
            }
            Plugin plugin = this.plugins.get(key);
            if (plugin == null) {
                if (!log.isInfoEnabled()) continue;
                log.info("No plugin was found for key '" + key + "'. Not enabling.");
                continue;
            }
            if (!plugin.getPluginInformation().satisfiesMinJavaVersion()) {
                log.error("Minimum Java version of '" + plugin.getPluginInformation().getMinJavaVersion() + "' was not satisfied for module '" + key + "'. Not enabling.");
                continue;
            }
            if (plugin.getPluginState() == PluginState.ENABLED) continue;
            pluginsToEnable.add(plugin);
        }
        Collection<Plugin> enabledPlugins = this.pluginEnabler.enableAllRecursively(pluginsToEnable);
        for (Plugin plugin : enabledPlugins) {
            this.enablePluginState(plugin, this.getStore());
            this.notifyPluginEnabled(plugin);
        }
    }

    @Override
    @Deprecated
    public void enablePlugin(String key) {
        this.enablePlugins(key);
    }

    protected void enablePluginState(Plugin plugin, PluginPersistentStateStore stateStore) {
        stateStore.save(this.getBuilder().setEnabled(plugin, true).toState());
    }

    protected void notifyPluginEnabled(Plugin plugin) {
        plugin.enable();
        if (this.enableConfiguredPluginModules(plugin)) {
            this.pluginEventManager.broadcast(new PluginEnabledEvent(plugin));
        }
    }

    private boolean enableConfiguredPluginModules(Plugin plugin) {
        boolean success = true;
        HashSet enabledDescriptors = new HashSet();
        for (ModuleDescriptor<?> descriptor : plugin.getModuleDescriptors()) {
            if (this.enableConfiguredPluginModule(plugin, descriptor, enabledDescriptors)) continue;
            success = false;
            break;
        }
        return success;
    }

    private boolean enableConfiguredPluginModule(Plugin plugin, ModuleDescriptor<?> descriptor, Set<ModuleDescriptor<?>> enabledDescriptors) {
        boolean success = true;
        try {
            if (this.pluginEnabler.isPluginBeingEnabled(plugin)) {
                log.debug("The plugin is currently being enabled, so we won't bother trying to enable the '" + descriptor.getKey() + " module");
                return success;
            }
            if (!this.isPluginModuleEnabled(descriptor.getCompleteKey())) {
                if (log.isDebugEnabled()) {
                    String name = descriptor.getName() == null ? descriptor.getKey() : descriptor.getName();
                    log.debug("Plugin module '" + name + "' is explicitly disabled (or so by default), so not re-enabling.");
                }
                return success;
            }
            this.notifyModuleEnabled(descriptor);
            enabledDescriptors.add(descriptor);
        }
        catch (Throwable exception) {
            log.error("There was an error loading the descriptor '" + descriptor.getName() + "' of plugin '" + plugin.getKey() + "'. Disabling.", exception);
            for (ModuleDescriptor<?> desc : enabledDescriptors) {
                try {
                    this.notifyModuleDisabled(desc);
                }
                catch (Exception ex2) {
                    log.error("Could not notify previously enabled descriptor {} of module disabled in plugin {}", (Object)desc.getName(), (Object)plugin.getKey());
                    log.info("Stacktrace : ", (Throwable)ex2);
                }
            }
            this.replacePluginWithUnloadablePlugin(plugin, descriptor, exception);
            success = false;
        }
        return success;
    }

    @Override
    public void disablePlugin(String key) {
        this.disablePluginInternal(key, true);
    }

    @Override
    public void disablePluginWithoutPersisting(String key) {
        this.disablePluginInternal(key, false);
    }

    protected void disablePluginInternal(String key, boolean persistDisabledState) {
        if (key == null) {
            throw new IllegalArgumentException("You must specify a plugin key to disable.");
        }
        Plugin plugin = this.plugins.get(key);
        if (plugin == null) {
            if (log.isInfoEnabled()) {
                log.info("No plugin was found for key '" + key + "'. Not disabling.");
            }
            return;
        }
        if (plugin.getPluginState() != PluginState.DISABLED) {
            this.notifyPluginDisabled(plugin);
            if (persistDisabledState) {
                this.disablePluginState(plugin, this.getStore());
            }
        }
    }

    protected void disablePluginState(Plugin plugin, PluginPersistentStateStore stateStore) {
        stateStore.save(this.getBuilder().setEnabled(plugin, false).toState());
    }

    protected void notifyPluginDisabled(Plugin plugin) {
        if (log.isInfoEnabled()) {
            log.info("Disabling " + plugin.getKey());
        }
        this.broadcastIgnoreError(new BeforePluginDisabledEvent(plugin));
        this.disablePluginModules(plugin);
        plugin.disable();
        this.broadcastIgnoreError(new PluginDisabledEvent(plugin));
    }

    private void disablePluginModules(Plugin plugin) {
        ArrayList moduleDescriptors = new ArrayList(plugin.getModuleDescriptors());
        Collections.reverse(moduleDescriptors);
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            this.disablePluginModuleNoPersist(moduleDescriptor);
        }
    }

    private void disablePluginModuleNoPersist(ModuleDescriptor<?> module) {
        if (this.isPluginModuleEnabled(module.getCompleteKey())) {
            this.publishModuleDisabledEvents(module, false);
        }
    }

    @Override
    public void disablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor<?> module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info("Returned module for key '" + completeKey + "' was null. Not disabling.");
            }
            return;
        }
        if (module.getClass().isAnnotationPresent(CannotDisable.class)) {
            if (log.isInfoEnabled()) {
                log.info("Plugin module " + completeKey + " cannot be disabled; it is annotated with" + CannotDisable.class.getName());
            }
            return;
        }
        this.disablePluginModuleState(module, this.getStore());
        this.notifyModuleDisabled(module);
    }

    protected void disablePluginModuleState(ModuleDescriptor<?> module, PluginPersistentStateStore stateStore) {
        stateStore.save(this.getBuilder().setEnabled(module, false).toState());
    }

    protected void notifyModuleDisabled(ModuleDescriptor<?> module) {
        this.publishModuleDisabledEvents(module, true);
    }

    private void publishModuleDisabledEvents(ModuleDescriptor<?> module, boolean persistent) {
        if (log.isDebugEnabled()) {
            log.debug("Disabling " + module.getKey());
        }
        this.broadcastIgnoreError(new BeforePluginModuleDisabledEvent(module, persistent));
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).disabled();
        }
        this.broadcastIgnoreError(new PluginModuleDisabledEvent(module, persistent));
    }

    @Override
    public void enablePluginModule(String completeKey) {
        if (completeKey == null) {
            throw new IllegalArgumentException("You must specify a plugin module key to disable.");
        }
        ModuleDescriptor<?> module = this.getPluginModule(completeKey);
        if (module == null) {
            if (log.isInfoEnabled()) {
                log.info("Returned module for key '" + completeKey + "' was null. Not enabling.");
            }
            return;
        }
        if (!module.satisfiesMinJavaVersion()) {
            log.error("Minimum Java version of '" + module.getMinJavaVersion() + "' was not satisfied for module '" + completeKey + "'. Not enabling.");
            return;
        }
        this.enablePluginModuleState(module, this.getStore());
        this.notifyModuleEnabled(module);
    }

    protected void enablePluginModuleState(ModuleDescriptor<?> module, PluginPersistentStateStore stateStore) {
        stateStore.save(this.getBuilder().setEnabled(module, true).toState());
    }

    protected void notifyModuleEnabled(ModuleDescriptor<?> module) {
        if (log.isDebugEnabled()) {
            log.debug("Enabling " + module.getKey());
        }
        if (module instanceof StateAware) {
            ((StateAware)((Object)module)).enabled();
        }
        this.pluginEventManager.broadcast(new PluginModuleEnabledEvent(module));
    }

    @Override
    public boolean isPluginModuleEnabled(String completeKey) {
        return completeKey != null && this.isPluginModuleEnabled(new ModuleCompleteKey(completeKey));
    }

    private boolean isPluginModuleEnabled(ModuleCompleteKey key) {
        if (!this.isPluginEnabled(key.getPluginKey())) {
            return false;
        }
        ModuleDescriptor<?> pluginModule = this.getPluginModule(key);
        return pluginModule != null && this.getState().isEnabled(pluginModule);
    }

    @Override
    public boolean isPluginEnabled(String key) {
        Plugin plugin = this.plugins.get(Assertions.notNull("The plugin key must be specified", key));
        return plugin != null && plugin.getPluginState() == PluginState.ENABLED && this.getState().isEnabled(plugin) && !this.pluginEnabler.isPluginBeingEnabled(plugin);
    }

    @Override
    public InputStream getDynamicResourceAsStream(String name) {
        return this.getClassLoader().getResourceAsStream(name);
    }

    @Override
    public Class<?> getDynamicPluginClass(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }

    @Override
    public PluginsClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public InputStream getPluginResourceAsStream(String pluginKey, String resourcePath) {
        Plugin plugin = this.getEnabledPlugin(pluginKey);
        if (plugin == null) {
            log.error("Attempted to retreive resource " + resourcePath + " for non-existent or inactive plugin " + pluginKey);
            return null;
        }
        return plugin.getResourceAsStream(resourcePath);
    }

    private UnloadablePlugin replacePluginWithUnloadablePlugin(Plugin plugin, ModuleDescriptor<?> descriptor, Throwable throwable) {
        UnloadableModuleDescriptor unloadableDescriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, descriptor, throwable);
        UnloadablePlugin unloadablePlugin = UnloadablePluginFactory.createUnloadablePlugin(plugin, unloadableDescriptor);
        unloadablePlugin.setErrorText(unloadableDescriptor.getErrorText());
        this.plugins.put(plugin.getKey(), unloadablePlugin);
        return unloadablePlugin;
    }

    @Override
    public boolean isSystemPlugin(String key) {
        Plugin plugin = this.getPlugin(key);
        return plugin != null && plugin.isSystemPlugin();
    }

    @Override
    public PluginRestartState getPluginRestartState(String key) {
        return this.getState().getPluginRestartState(key);
    }

    private PluginPersistentState.Builder getBuilder() {
        return PluginPersistentState.Builder.create(this.getStore().load());
    }

    private void broadcastIgnoreError(Object event) {
        block2: {
            try {
                this.pluginEventManager.broadcast(event);
            }
            catch (NotificationException ex) {
                log.warn("Error broadcasting '{}': {}.  Continuing anyway.", (Object)event.getClass().getName(), (Object)ex.getMessage());
                if (!log.isDebugEnabled()) break block2;
                log.debug(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    @Deprecated
    public void setDescriptorParserFactory(DescriptorParserFactory descriptorParserFactory) {
    }

    @Internal
    public static enum PluginSortMode {
        SORTED,
        LEGACY,
        SHUFFLE;

        private static final String PROPERTY_NAME;

        static PluginSortMode current() {
            String propertyValue = System.getProperty(PROPERTY_NAME);
            if (null != propertyValue) {
                for (PluginSortMode pluginSortMode : PluginSortMode.values()) {
                    if (!pluginSortMode.name().equalsIgnoreCase(propertyValue)) continue;
                    return pluginSortMode;
                }
            }
            return SORTED;
        }

        static {
            PROPERTY_NAME = DefaultPluginManager.class.getName() + ".pluginSortMode";
        }
    }
}

