/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginParseException;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JarPluginArtifact
implements PluginArtifact,
PluginArtifact.AllowsReference {
    private static final Logger log = LoggerFactory.getLogger(JarPluginArtifact.class);
    private final File jarFile;
    final PluginArtifact.AllowsReference.ReferenceMode referenceMode;

    public JarPluginArtifact(File jarFile) {
        this(jarFile, PluginArtifact.AllowsReference.ReferenceMode.FORBID_REFERENCE);
    }

    public JarPluginArtifact(File jarFile, PluginArtifact.AllowsReference.ReferenceMode referenceMode) {
        this.jarFile = (File)Preconditions.checkNotNull((Object)jarFile);
        this.referenceMode = referenceMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doesResourceExist(String name) {
        InputStream in = null;
        try {
            in = this.getResourceAsStream(name);
            boolean bl = in != null;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    @Override
    public InputStream getResourceAsStream(String fileName) throws PluginParseException {
        Preconditions.checkNotNull((Object)fileName, (Object)"The file name must not be null");
        final JarFile jar = this.open();
        ZipEntry entry = jar.getEntry(fileName);
        if (entry == null) {
            this.closeJarQuietly(jar);
            return null;
        }
        try {
            return new BufferedInputStream(jar.getInputStream(entry)){

                @Override
                public void close() throws IOException {
                    super.close();
                    jar.close();
                }
            };
        }
        catch (IOException e) {
            throw new PluginParseException("Cannot retrieve " + fileName + " from plugin JAR [" + this.jarFile + "]", e);
        }
    }

    @Override
    public String getName() {
        return this.jarFile.getName();
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.jarFile));
        }
        catch (FileNotFoundException e) {
            throw new PluginParseException("Could not open JAR file: " + this.jarFile, e);
        }
    }

    @Override
    public File toFile() {
        return this.jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsJavaExecutableCode() {
        JarFile jar = this.open();
        try {
            Manifest manifest = this.getManifest(jar);
            boolean bl = this.hasBundleActivator(manifest) || this.hasSpringContext(manifest) || Iterators.any((Iterator)Iterators.forEnumeration(jar.entries()), (Predicate)new Predicate<JarEntry>(){

                public boolean apply(JarEntry entry) {
                    return JarPluginArtifact.this.isJavaClass(entry) || JarPluginArtifact.this.isJavaLibrary(entry) || JarPluginArtifact.this.isSpringContext(entry);
                }
            });
            return bl;
        }
        finally {
            this.closeJarQuietly(jar);
        }
    }

    @Override
    public boolean allowsReference() {
        return this.referenceMode.allowsReference();
    }

    private boolean isJavaClass(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }

    private boolean isJavaLibrary(ZipEntry entry) {
        return entry.getName().endsWith(".jar");
    }

    private boolean isSpringContext(ZipEntry entry) {
        String entryName = entry.getName();
        return entryName.startsWith("META-INF/spring/") && entryName.endsWith(".xml");
    }

    private boolean hasSpringContext(Manifest manifest) {
        return this.hasManifestEntry(manifest, "Spring-Context");
    }

    private boolean hasBundleActivator(Manifest manifest) {
        return this.hasManifestEntry(manifest, "Bundle-Activator");
    }

    private boolean hasManifestEntry(Manifest manifest, String manifestEntryName) {
        return manifest != null && manifest.getMainAttributes() != null && manifest.getMainAttributes().getValue(manifestEntryName) != null;
    }

    private JarFile open() {
        try {
            return new JarFile(this.jarFile);
        }
        catch (IOException e) {
            throw new PluginParseException("Cannot open JAR file: " + this.jarFile, e);
        }
    }

    private Manifest getManifest(JarFile jar) {
        try {
            return jar.getManifest();
        }
        catch (IOException e) {
            throw new PluginParseException("Cannot get manifest for JAR file: " + this.jarFile, e);
        }
    }

    private void closeJarQuietly(JarFile jar) {
        if (jar != null) {
            try {
                jar.close();
            }
            catch (IOException ignored) {
                log.debug("Exception closing jar file " + this.jarFile + ".", (Throwable)ignored);
            }
        }
    }
}

