/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.impl;

import com.atlassian.plugin.JarPluginArtifact;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactBackedPlugin;
import com.atlassian.plugin.classloader.PluginClassLoader;
import com.atlassian.plugin.impl.AbstractPlugin;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.net.URL;

public class DefaultDynamicPlugin
extends AbstractPlugin
implements PluginArtifactBackedPlugin {
    private final PluginArtifact pluginArtifact;
    private final PluginClassLoader loader;

    public DefaultDynamicPlugin(DeploymentUnit deploymentUnit, PluginClassLoader loader) {
        this(new JarPluginArtifact(deploymentUnit.getPath()), loader);
    }

    public DefaultDynamicPlugin(PluginArtifact pluginArtifact, PluginClassLoader loader) {
        this.pluginArtifact = (PluginArtifact)Preconditions.checkNotNull((Object)pluginArtifact);
        this.loader = (PluginClassLoader)Preconditions.checkNotNull((Object)loader);
    }

    @Override
    public <T> Class<T> loadClass(String clazz, Class<?> callingClass) throws ClassNotFoundException {
        Class<?> result = this.loader.loadClass(clazz);
        return result;
    }

    @Override
    public boolean isUninstallable() {
        return true;
    }

    @Override
    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.loader.getResourceAsStream(name);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.loader;
    }

    @Override
    public boolean isDynamicallyLoaded() {
        return true;
    }

    public DeploymentUnit getDeploymentUnit() {
        return new DeploymentUnit(this.pluginArtifact.toFile());
    }

    @Override
    public PluginArtifact getPluginArtifact() {
        return this.pluginArtifact;
    }

    @Override
    public boolean isDeleteable() {
        return true;
    }

    @Override
    public boolean isBundledPlugin() {
        return false;
    }

    @Override
    protected void uninstallInternal() {
        this.loader.close();
    }
}

