/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin;

import com.atlassian.plugin.PluginPermission;
import com.atlassian.plugin.util.JavaVersionUtils;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class PluginInformation {
    private String description = "";
    private String descriptionKey;
    private String version = "0.0";
    private String vendorName = "(unknown)";
    private String vendorUrl;
    private float maxVersion;
    private float minVersion;
    private Float minJavaVersion;
    private Set<PluginPermission> permissions = ImmutableSet.of();
    private final Map<String, String> parameters = CopyOnWriteMap.builder().stableViews().newHashMap();
    private String startup;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVendorName(String vendorName) {
        this.vendorName = vendorName;
    }

    public void setVendorUrl(String vendorUrl) {
        this.vendorUrl = vendorUrl;
    }

    public String getVendorName() {
        return this.vendorName;
    }

    public String getVendorUrl() {
        return this.vendorUrl;
    }

    @Deprecated
    public void setMaxVersion(float maxVersion) {
        this.maxVersion = maxVersion;
    }

    @Deprecated
    public void setMinVersion(float minVersion) {
        this.minVersion = minVersion;
    }

    @Deprecated
    public float getMaxVersion() {
        return this.maxVersion;
    }

    @Deprecated
    public float getMinVersion() {
        return this.minVersion;
    }

    public Float getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public void setMinJavaVersion(Float minJavaVersion) {
        this.minJavaVersion = minJavaVersion;
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public Set<PluginPermission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<PluginPermission> permissions) {
        this.permissions = ImmutableSet.copyOf(permissions);
    }

    public void addParameter(String key, String value) {
        this.parameters.put(key, value);
    }

    public boolean satisfiesMinJavaVersion() {
        return this.minJavaVersion == null || JavaVersionUtils.satisfiesMinVersion(this.minJavaVersion.floatValue());
    }

    public void setDescriptionKey(String descriptionKey) {
        this.descriptionKey = descriptionKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public String getStartup() {
        return this.startup;
    }

    public void setStartup(String startup) {
        this.startup = startup;
    }
}

