/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.loaders;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.DefaultPluginArtifactFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactBackedPlugin;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.factories.PluginFactory;
import com.atlassian.plugin.impl.AbstractDelegatingPlugin;
import com.atlassian.plugin.loaders.DirectoryScanner;
import com.atlassian.plugin.loaders.FileListScanner;
import com.atlassian.plugin.loaders.ScanningPluginLoader;
import com.atlassian.plugin.loaders.classloading.DeploymentUnit;
import com.atlassian.plugin.loaders.classloading.EmptyScanner;
import com.atlassian.plugin.loaders.classloading.ForwardingScanner;
import com.atlassian.plugin.loaders.classloading.Scanner;
import com.atlassian.plugin.module.ContainerAccessor;
import com.atlassian.plugin.module.ContainerManagedPlugin;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundledPluginLoader
extends ScanningPluginLoader {
    private static final Logger log = LoggerFactory.getLogger(BundledPluginLoader.class);

    public static String getListSuffix() {
        return ".list";
    }

    private BundledPluginLoader(Scanner scanner, List<PluginFactory> pluginFactories, PluginEventManager eventManager) {
        super(new NonRemovingScanner(scanner), pluginFactories, new DefaultPluginArtifactFactory(PluginArtifact.AllowsReference.ReferenceMode.PERMIT_REFERENCE), eventManager);
    }

    public BundledPluginLoader(File source, List<PluginFactory> pluginFactories, PluginEventManager eventManager) {
        this(BundledPluginLoader.buildSourceScanner(source), pluginFactories, eventManager);
    }

    public BundledPluginLoader(URL zipUrl, File pluginPath, List<PluginFactory> pluginFactories, PluginEventManager eventManager) {
        this(BundledPluginLoader.buildZipScanner(zipUrl, pluginPath), pluginFactories, eventManager);
    }

    @Override
    protected Plugin postProcess(Plugin plugin) {
        if (plugin instanceof ContainerManagedPlugin) {
            return new BundledPluginContainerManagedPluginDelegate((ContainerManagedPlugin)plugin);
        }
        if (plugin instanceof PluginArtifactBackedPlugin) {
            return new BundledPluginArtifactBackedPluginDelegate((PluginArtifactBackedPlugin)plugin);
        }
        return new BundledPluginDelegate(plugin);
    }

    private static Scanner buildScannerCommon(File file) {
        if (file.isDirectory()) {
            return new DirectoryScanner(file);
        }
        if (file.isFile() && file.getName().endsWith(BundledPluginLoader.getListSuffix())) {
            List<File> files = BundledPluginLoader.readListFile(file);
            return new FileListScanner(files);
        }
        return null;
    }

    private static Scanner buildSourceScanner(File source) {
        Preconditions.checkNotNull((Object)source, (Object)"Source must not be null");
        Scanner scanner = BundledPluginLoader.buildScannerCommon(source);
        if (null == scanner) {
            log.error("Cannot build a scanner for source '{}'", (Object)source);
            return new EmptyScanner();
        }
        return scanner;
    }

    private static Scanner buildZipScanner(URL url, File pluginPath) {
        Preconditions.checkArgument((null != url ? 1 : 0) != 0, (Object)"Bundled plugins url cannot be null");
        Scanner scanner = null;
        File file = FileUtils.toFile((URL)url);
        if (null != file) {
            scanner = BundledPluginLoader.buildScannerCommon(file);
        }
        if (null == scanner) {
            com.atlassian.plugin.util.FileUtils.conditionallyExtractZipFile(url, pluginPath);
            scanner = new DirectoryScanner(pluginPath);
        }
        return scanner;
    }

    private static List<File> readListFile(File file) {
        try {
            List fnames = FileUtils.readLines((File)file);
            ArrayList<File> files = new ArrayList<File>();
            for (String fname : fnames) {
                files.add(new File(fname));
            }
            return files;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read list from " + file, e);
        }
    }

    private static class BundledPluginContainerManagedPluginDelegate
    extends BundledPluginArtifactBackedPluginDelegate
    implements ContainerManagedPlugin,
    AutowireCapablePlugin {
        private final ContainerManagedPlugin delegate;

        private BundledPluginContainerManagedPluginDelegate(ContainerManagedPlugin delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public ContainerAccessor getContainerAccessor() {
            return this.delegate.getContainerAccessor();
        }

        @Override
        public <T> T autowire(Class<T> clazz) {
            if (this.delegate instanceof AutowireCapablePlugin) {
                return ((AutowireCapablePlugin)((Object)this.delegate)).autowire(clazz);
            }
            return this.delegate.getContainerAccessor().createBean(clazz);
        }

        @Override
        public <T> T autowire(Class<T> clazz, AutowireCapablePlugin.AutowireStrategy autowireStrategy) {
            if (this.delegate instanceof AutowireCapablePlugin) {
                return ((AutowireCapablePlugin)((Object)this.delegate)).autowire(clazz, autowireStrategy);
            }
            return this.delegate.getContainerAccessor().createBean(clazz);
        }

        @Override
        public void autowire(Object instance) {
            if (this.delegate instanceof AutowireCapablePlugin) {
                ((AutowireCapablePlugin)((Object)this.delegate)).autowire(instance);
            } else {
                this.delegate.getContainerAccessor().injectBean(instance);
            }
        }

        @Override
        public void autowire(Object instance, AutowireCapablePlugin.AutowireStrategy autowireStrategy) {
            if (this.delegate instanceof AutowireCapablePlugin) {
                ((AutowireCapablePlugin)((Object)this.delegate)).autowire(instance, autowireStrategy);
            } else {
                this.delegate.getContainerAccessor().injectBean(instance);
            }
        }
    }

    private static class BundledPluginArtifactBackedPluginDelegate
    extends BundledPluginDelegate
    implements PluginArtifactBackedPlugin {
        private final PluginArtifactBackedPlugin delegate;

        private BundledPluginArtifactBackedPluginDelegate(PluginArtifactBackedPlugin delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        @Override
        public PluginArtifact getPluginArtifact() {
            return this.delegate.getPluginArtifact();
        }
    }

    private static class BundledPluginDelegate
    extends AbstractDelegatingPlugin {
        public BundledPluginDelegate(Plugin delegate) {
            super(delegate);
        }

        @Override
        public boolean isBundledPlugin() {
            return true;
        }
    }

    private static class NonRemovingScanner
    extends ForwardingScanner {
        NonRemovingScanner(Scanner scanner) {
            super(scanner);
        }

        @Override
        public void remove(DeploymentUnit unit) throws PluginException {
        }
    }
}

