/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.parsers;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.InstallationMode;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.parsers.ModuleReader;
import com.atlassian.plugin.parsers.PluginInformationReader;
import com.atlassian.plugin.parsers.XmlDescriptorParserUtils;
import com.atlassian.plugin.util.PluginUtils;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PluginDescriptorReader {
    static final String RESOURCE = "resource";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Document descriptor;
    private final Set<Application> applications;

    public PluginDescriptorReader(Document descriptor, Set<Application> applications) {
        this.descriptor = XmlDescriptorParserUtils.removeAllNamespaces((Document)Preconditions.checkNotNull((Object)descriptor));
        this.applications = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(applications)));
    }

    public Document getDescriptor() {
        return this.descriptor;
    }

    private Element getPluginElement() {
        return this.descriptor.getRootElement();
    }

    public String getPluginKey() {
        return this.getPluginElement().attributeValue("key");
    }

    public String getPluginName() {
        return this.getPluginElement().attributeValue("name");
    }

    public boolean isSystemPlugin() {
        return Boolean.valueOf(this.getPluginElement().attributeValue("system"));
    }

    public Option<String> getI18nPluginNameKey() {
        return Option.option((Object)this.getPluginElement().attributeValue("i18n-name-key"));
    }

    public boolean isEnabledByDefault() {
        return !"disabled".equalsIgnoreCase(this.getPluginElement().attributeValue("state"));
    }

    public Option<Element> getPluginInformation() {
        return Iterables.findFirst(PluginDescriptorReader.elements(this.getPluginElement()), (Predicate)new ElementWithName("plugin-info"));
    }

    public PluginInformationReader getPluginInformationReader() {
        return new PluginInformationReader(this.getPluginInformation(), this.applications, this.getPluginsVersion());
    }

    public Iterable<Element> getModules(final InstallationMode installationMode) {
        return com.google.common.collect.Iterables.filter((Iterable)com.google.common.collect.Iterables.filter(PluginDescriptorReader.elements(this.getPluginElement()), (Predicate)Predicates.not((Predicate)Predicates.or((Predicate)new ElementWithName("plugin-info"), (Predicate)new ElementWithName(RESOURCE)))), (Predicate)new Predicate<Element>(){

            public boolean apply(Element module) {
                if (!PluginUtils.doesModuleElementApplyToApplication(module, PluginDescriptorReader.this.applications, installationMode)) {
                    PluginDescriptorReader.this.logger.debug("Ignoring module descriptor for this application: {}", (Object)module.attributeValue("key"));
                    return false;
                }
                return true;
            }
        });
    }

    public Iterable<ModuleReader> getModuleReaders(InstallationMode installationMode) {
        return com.google.common.collect.Iterables.transform(this.getModules(installationMode), (Function)new Function<Element, ModuleReader>(){

            public ModuleReader apply(Element module) {
                return new ModuleReader(module);
            }
        });
    }

    public Resources getResources() {
        return Resources.fromXml(this.getPluginElement());
    }

    public int getPluginsVersion() {
        String val = this.getPluginElement().attributeValue("pluginsVersion");
        if (val == null) {
            val = this.getPluginElement().attributeValue("plugins-version");
        }
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Could not parse pluginsVersion: " + e.getMessage(), e);
            }
        }
        return 1;
    }

    static List<Element> elements(Element e) {
        return e.elements();
    }

    static List<Element> elements(Element e, String name) {
        return e != null ? e.elements(name) : ImmutableList.of();
    }

    private static final class ElementWithName
    implements Predicate<Element> {
        private final String name;

        private ElementWithName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
        }

        public boolean apply(@Nullable Element element) {
            return element != null && this.name.equalsIgnoreCase(element.getName());
        }
    }
}

