package com.atlassian.plugin.event.events;

import com.atlassian.plugin.ModuleDescriptor;

/**
 * Event fired when a plugin module is about to be disabled, which can also happen when its
 * plugin is about to be disabled or uninstalled.
 *
 * @see com.atlassian.plugin.event.events
 */
public class BeforePluginModuleDisabledEvent
{
    private final ModuleDescriptor<?> module;
    private final boolean persistent;

    public BeforePluginModuleDisabledEvent(ModuleDescriptor<?> module, boolean persistent)
    {
        this.module = module;
        this.persistent = persistent;
    }

    public ModuleDescriptor<?> getModule()
    {
        return module;
    }

    /**
     * @return <code>true</code> if this disabling will be persistent, i.e. it is not a transient, such as for an
     *  upgrade.
     */
    public boolean isPersistent()
    {
        return persistent;
    }
}
