/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.util.zip;

import com.atlassian.plugin.util.zip.FileUnzipper;
import com.atlassian.plugin.util.zip.Unzipper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractUnzipper
implements Unzipper {
    protected static Logger log = LoggerFactory.getLogger(FileUnzipper.class);
    protected File destDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected File saveEntry(InputStream is, ZipEntry entry) throws IOException {
        File file;
        block6: {
            FileOutputStream fos;
            file = new File(this.destDir, entry.getName());
            if (entry.isDirectory()) {
                file.mkdirs();
            } else {
                File dir = new File(file.getParent());
                dir.mkdirs();
                fos = null;
                fos = new FileOutputStream(file);
                IOUtils.copy((InputStream)is, (OutputStream)fos);
                fos.flush();
                IOUtils.closeQuietly((OutputStream)fos);
            }
            break block6;
            catch (FileNotFoundException fnfe) {
                File file2;
                try {
                    log.error("Error extracting a file to '" + this.destDir + File.separator + entry.getName() + "'. This destination is invalid for writing an extracted file stream to. ");
                    file2 = null;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fos);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)fos);
                return file2;
            }
        }
        file.setLastModified(entry.getTime());
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ZipEntry[] entries(ZipInputStream zis) throws IOException {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        try {
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                entries.add(zipEntry);
                zis.closeEntry();
                zipEntry = zis.getNextEntry();
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)zis);
        }
        return entries.toArray(new ZipEntry[entries.size()]);
    }

    @Override
    public void conditionalUnzip() throws IOException {
        HashMap<String, Long> zipContentsAndLastModified = new HashMap<String, Long>();
        ZipEntry[] zipEntries = this.entries();
        for (int i = 0; i < zipEntries.length; ++i) {
            zipContentsAndLastModified.put(zipEntries[i].getName(), zipEntries[i].getTime());
        }
        Map<String, Long> targetDirContents = this.getContentsOfTargetDir(this.destDir);
        if (!targetDirContents.equals(zipContentsAndLastModified)) {
            if (this.destDir.exists()) {
                FileUtils.cleanDirectory((File)this.destDir);
            }
            this.unzip();
        } else if (log.isDebugEnabled()) {
            log.debug("Target directory contents match zip contents. Do nothing.");
        }
    }

    private Map<String, Long> getContentsOfTargetDir(File dir) {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        };
        if (!dir.isDirectory()) {
            return Collections.emptyMap();
        }
        HashMap<String, Long> targetDirContents = new HashMap<String, Long>();
        for (File child : dir.listFiles()) {
            if (log.isDebugEnabled()) {
                log.debug("Examining entry in zip: " + child);
            }
            targetDirContents.put(child.getName(), child.lastModified());
        }
        return targetDirContents;
    }
}

