/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.parsers;

import com.atlassian.fugue.Option;
import com.atlassian.plugin.Application;
import com.atlassian.plugin.InstallationMode;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginInformation;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.PluginPermission;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptor;
import com.atlassian.plugin.descriptors.UnloadableModuleDescriptorFactory;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptor;
import com.atlassian.plugin.descriptors.UnrecognisedModuleDescriptorFactory;
import com.atlassian.plugin.impl.UnloadablePluginFactory;
import com.atlassian.plugin.parsers.DescriptorParser;
import com.atlassian.plugin.parsers.PluginDescriptorReader;
import com.atlassian.plugin.parsers.PluginInformationReader;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDescriptorParser
implements DescriptorParser {
    private static final Logger log = LoggerFactory.getLogger(XmlDescriptorParser.class);
    private final PluginDescriptorReader descriptorReader;

    public XmlDescriptorParser(Document source, Set<Application> applications) throws PluginParseException {
        this.descriptorReader = new PluginDescriptorReader((Document)Preconditions.checkNotNull((Object)source, (Object)"XML descriptor source document cannot be null"), (Set)Preconditions.checkNotNull(applications));
    }

    public XmlDescriptorParser(InputStream source, Set<Application> applications) throws PluginParseException {
        this(XmlDescriptorParser.createDocument((InputStream)Preconditions.checkNotNull((Object)source, (Object)"XML descriptor source cannot be null")), applications);
    }

    protected static Document createDocument(InputStream source) throws PluginParseException {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        try {
            return reader.read(source);
        }
        catch (DocumentException e) {
            throw new PluginParseException("Cannot parse XML plugin descriptor", e);
        }
    }

    protected Document getDocument() {
        return this.descriptorReader.getDescriptor();
    }

    @Override
    public Plugin configurePlugin(ModuleDescriptorFactory moduleDescriptorFactory, Plugin plugin) throws PluginParseException {
        plugin.setName(this.descriptorReader.getPluginName());
        plugin.setKey(this.getKey());
        plugin.setPluginsVersion(this.getPluginsVersion());
        plugin.setSystemPlugin(this.isSystemPlugin());
        plugin.setI18nNameKey((String)this.descriptorReader.getI18nPluginNameKey().getOrElse((Object)plugin.getI18nNameKey()));
        if (plugin.getKey().indexOf(":") > 0) {
            throw new PluginParseException("Plugin keys cannot contain ':'. Key is '" + plugin.getKey() + "'");
        }
        plugin.setEnabledByDefault(this.descriptorReader.isEnabledByDefault());
        plugin.setResources(this.descriptorReader.getResources());
        plugin.setPluginInformation(this.createPluginInformation());
        for (Element module : this.descriptorReader.getModules(plugin.getInstallationMode())) {
            ModuleDescriptor<?> moduleDescriptor = this.createModuleDescriptor(plugin, module, moduleDescriptorFactory);
            if (moduleDescriptor == null) continue;
            if (plugin.getModuleDescriptor(moduleDescriptor.getKey()) != null) {
                throw new PluginParseException("Found duplicate key '" + moduleDescriptor.getKey() + "' within plugin '" + plugin.getKey() + "'");
            }
            plugin.addModuleDescriptor(moduleDescriptor);
            if (!(moduleDescriptor instanceof UnloadableModuleDescriptor)) continue;
            log.error("There were errors loading the plugin '" + plugin.getName() + "'. The plugin has been disabled.");
            return UnloadablePluginFactory.createUnloadablePlugin(plugin);
        }
        return plugin;
    }

    protected ModuleDescriptor<?> createModuleDescriptor(Plugin plugin, Element element, ModuleDescriptorFactory moduleDescriptorFactory) throws PluginParseException {
        ModuleDescriptor<?> moduleDescriptorDescriptor;
        String name = element.getName();
        try {
            moduleDescriptorDescriptor = moduleDescriptorFactory.getModuleDescriptor(name);
        }
        catch (Throwable e) {
            UnrecognisedModuleDescriptor descriptor = UnrecognisedModuleDescriptorFactory.createUnrecognisedModuleDescriptor(plugin, element, e, moduleDescriptorFactory);
            log.error("There were problems loading the module '{}' in plugin '{}'. The module has been disabled.", (Object)name, (Object)plugin.getName());
            log.error(descriptor.getErrorText(), e);
            return descriptor;
        }
        if (moduleDescriptorDescriptor == null) {
            log.info("The module '{}' in plugin '{}' is in the list of excluded module descriptors, so not enabling.", (Object)name, (Object)plugin.getName());
            return null;
        }
        try {
            moduleDescriptorDescriptor.init(plugin, element);
        }
        catch (Exception e) {
            UnloadableModuleDescriptor descriptor = UnloadableModuleDescriptorFactory.createUnloadableModuleDescriptor(plugin, element, e, moduleDescriptorFactory);
            log.error("There were problems loading the module '{}'. The module and its plugin have been disabled.", (Object)name);
            log.error(descriptor.getErrorText(), (Throwable)e);
            return descriptor;
        }
        return moduleDescriptorDescriptor;
    }

    protected PluginInformation createPluginInformation() {
        PluginInformationReader pluginInformationReader = this.descriptorReader.getPluginInformationReader();
        PluginInformation pluginInfo = new PluginInformation();
        pluginInfo.setDescription((String)pluginInformationReader.getDescription().getOrElse((Object)pluginInfo.getDescription()));
        pluginInfo.setDescriptionKey((String)pluginInformationReader.getDescriptionKey().getOrElse((Object)pluginInfo.getDescriptionKey()));
        pluginInfo.setVersion((String)pluginInformationReader.getVersion().getOrElse((Object)pluginInfo.getVersion()));
        pluginInfo.setVendorName((String)pluginInformationReader.getVendorName().getOrElse((Object)pluginInfo.getVendorName()));
        pluginInfo.setVendorUrl((String)pluginInformationReader.getVendorUrl().getOrElse((Object)pluginInfo.getVendorUrl()));
        for (Map.Entry<String, String> param : pluginInformationReader.getParameters().entrySet()) {
            pluginInfo.addParameter(param.getKey(), param.getValue());
        }
        pluginInfo.setMinVersion(((Float)pluginInformationReader.getMinVersion().getOrElse((Object)Float.valueOf(pluginInfo.getMinVersion()))).floatValue());
        pluginInfo.setMaxVersion(((Float)pluginInformationReader.getMaxVersion().getOrElse((Object)Float.valueOf(pluginInfo.getMaxVersion()))).floatValue());
        pluginInfo.setMinJavaVersion((Float)pluginInformationReader.getMinJavaVersion().getOrElse((Object)pluginInfo.getMinJavaVersion()));
        Map<String, Option<String>> readPermissions = pluginInformationReader.getPermissions();
        if (pluginInformationReader.hasAllPermissions()) {
            pluginInfo.setPermissions((Set<PluginPermission>)ImmutableSet.of((Object)PluginPermission.ALL));
        } else {
            ImmutableSet.Builder permissions = ImmutableSet.builder();
            for (Map.Entry<String, Option<String>> permission : readPermissions.entrySet()) {
                String permissionKey = permission.getKey();
                Option<String> readInstallationMode = permission.getValue();
                Option<InstallationMode> installationMode = InstallationMode.of((String)readInstallationMode.getOrNull());
                if (StringUtils.isNotBlank((String)((String)readInstallationMode.getOrNull())) && !installationMode.isDefined()) {
                    log.warn("The parsed installation mode '{}' for permission '{}' didn't match any of the valid values: {}", new Object[]{readInstallationMode, permission.getKey(), Iterables.transform((Iterable)ImmutableList.copyOf((Object[])InstallationMode.values()), (Function)new Function<InstallationMode, String>(){

                        public String apply(InstallationMode im) {
                            return im.getKey();
                        }
                    })});
                }
                permissions.add((Object)new PluginPermission(permissionKey, installationMode));
            }
            pluginInfo.setPermissions((Set<PluginPermission>)permissions.build());
        }
        return pluginInfo;
    }

    @Override
    public String getKey() {
        return this.descriptorReader.getPluginKey();
    }

    @Override
    public int getPluginsVersion() {
        return this.descriptorReader.getPluginsVersion();
    }

    @Override
    public PluginInformation getPluginInformation() {
        return this.createPluginInformation();
    }

    @Override
    public boolean isSystemPlugin() {
        return this.descriptorReader.isSystemPlugin();
    }
}

